/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.util.WeaponHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class SwordBaseItem
extends SwordItem
implements IWeaponTraitContainer<SwordBaseItem> {
    protected float field_150934_a = 1.0f;
    protected double attackSpeed = 0.0;
    protected List<WeaponTrait> traits;
    protected WeaponMaterial material;
    protected String customDisplayName = null;

    public SwordBaseItem(String regName, Item.Properties prop, WeaponMaterial material, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed, boolean usingDeferredRegister, WeaponTrait ... weaponTraits) {
        super((IItemTier)material, 3, -2.4f, prop.func_200918_c(material.func_200926_a()));
        if (!usingDeferredRegister) {
            this.setRegistryName(regName);
        }
        this.material = material;
        this.setAttackDamage(weaponBaseDamage, weaponDamageMultiplier);
        this.setAttackSpeed(weaponSpeed);
        this.traits = new ArrayList<WeaponTrait>();
        this.traits.addAll(Arrays.asList(weaponTraits));
        if (FMLEnvironment.dist.isClient()) {
            if (this.hasWeaponTrait(WeaponTraits.THROWABLE)) {
                ClientHelper.registerThrowingWeaponPropertyOverrides((Item)this);
            }
            if (this.hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
                ClientHelper.registerBlockablePropertyOverrides(this);
            }
        }
    }

    public SwordBaseItem(String regName, Item.Properties prop, WeaponMaterial material, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed, String customDisplayName, boolean usingDeferredRegister, WeaponTrait ... weaponTraits) {
        this(regName, prop, material, weaponBaseDamage, weaponDamageMultiplier, weaponSpeed, usingDeferredRegister, weaponTraits);
        if (material.useCustomDisplayName()) {
            this.customDisplayName = customDisplayName;
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            IMeleeTraitCallback callback;
            LivingEntity living = (LivingEntity)entity;
            if (this.traits != null) {
                for (WeaponTrait trait : this.traits) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
            if (this.material.hasAnyWeaponTrait()) {
                for (WeaponTrait property : this.material.getAllWeaponTraits()) {
                    callback = property.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
        }
    }

    public float func_200894_d() {
        return this.material.func_200929_c();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_200926_a();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        for (ToolType type : this.getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return this.material.func_200928_b();
        }
        return super.func_150893_a(stack, state);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            IMeleeTraitCallback callback;
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            if (this.traits != null) {
                for (WeaponTrait trait : this.traits) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onModifyAttibutesMelee((Multimap<Attribute, AttributeModifier>)multimap);
                }
            }
            if (this.material.hasAnyWeaponTrait()) {
                for (WeaponTrait property : this.material.getAllWeaponTraits()) {
                    callback = property.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onModifyAttibutesMelee((Multimap<Attribute, AttributeModifier>)multimap);
                }
            }
        }
        return multimap;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.hasWeaponTrait(WeaponTraits.SHIELD_BREACH);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.func_200295_i(stack);
        }
        return new TranslationTextComponent(this.customDisplayName, new Object[]{this.material.translateName()});
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = Screen.func_231173_s_();
        if (!this.traits.isEmpty()) {
            if (isShiftPressed) {
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.showing_details").func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GOLD));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.show_details", new Object[]{TextFormatting.AQUA.toString() + "SHIFT"}).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GOLD));
            }
            for (WeaponTrait trait : this.traits) {
                if (!trait.isMeleeTrait()) continue;
                trait.addTooltip(stack, tooltip, isShiftPressed);
            }
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
        if (this.material.hasAnyWeaponTrait()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits.material_bonus", "spartanweaponry")).func_240699_a_(TextFormatting.AQUA));
            for (WeaponTrait matTrait : this.material.getAllWeaponTraits()) {
                matTrait.addTooltip(stack, tooltip, isShiftPressed);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public float getDirectAttackDamage() {
        return this.field_150934_a;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IMeleeTraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasWeaponTrait(WeaponTraits.THROWABLE)) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        if (this.hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
            if (player.func_225608_bj_()) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (this.getFirstWeaponTraitWithType("throwable") != null && entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge >= 5) {
                charge = 5;
            }
            if (!worldIn.field_72995_K && charge > 2) {
                int k;
                ThrowingWeaponEntity thrown = new ThrowingWeaponEntity(ModEntities.THROWING_WEAPON, (LivingEntity)player, worldIn);
                thrown.setWeapon(stack);
                thrown.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f * ((float)charge / 10.0f + 0.5f), 0.5f);
                thrown.func_70239_b(this.getDirectAttackDamage() + 1.0f);
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
                if (j > 0) {
                    thrown.func_70239_b(thrown.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack)) > 0) {
                    thrown.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    worldIn.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.THROWING_KNIFE_THROW, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_217376_c((Entity)thrown);
                }
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.hasWeaponTrait(WeaponTraits.THROWABLE) || this.hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
            return 72000;
        }
        return super.func_77626_a(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.hasWeaponTrait(WeaponTraits.THROWABLE)) {
            return UseAction.SPEAR;
        }
        if (this.hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
            return UseAction.BLOCK;
        }
        return super.func_77661_b(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        IMeleeTraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            IMeleeTraitCallback callback;
            ItemStack stack = new ItemStack((IItemProvider)this);
            for (WeaponTrait trait : this.traits) {
                callback = trait.getMeleeCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
                callback = trait.getMeleeCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            items.add((Object)stack);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        WeaponHelper.inflictAttackDamage(this, player, entity);
        return true;
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        return super.getCreatorModId(itemStack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getFirstWeaponTraitWithType("sweep_damage") == null) {
            return enchantment != Enchantments.field_191530_r && super.canApplyAtEnchantingTable(stack, enchantment);
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean hasWeaponTrait(WeaponTrait prop) {
        return this.traits.contains(prop);
    }

    @Override
    public SwordBaseItem addWeaponTrait(WeaponTrait prop) {
        this.traits.add(prop);
        return this;
    }

    @Override
    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            return property;
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraitsWithType(String type) {
        ArrayList<WeaponTrait> result = new ArrayList<WeaponTrait>();
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            result.add(trait);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraits() {
        return ImmutableList.copyOf(this.traits);
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public void setAttackDamage(float baseDamage, float damageMultiplier) {
        this.field_150934_a = this.material.func_200929_c() * damageMultiplier + baseDamage - 1.0f;
    }

    public void setAttackSpeed(double speed) {
        this.attackSpeed = speed;
    }
}

