/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.entity.projectile.BoltEntity;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BoltItem
extends Item {
    protected float damageModifier = 4.0f;
    protected float rangeModifier = 1.0f;
    protected float armorPiercingFactor = 0.25f;

    public BoltItem(String unlocName, float damageModifier, float rangeModifier, float armorPiercingFactor) {
        super(new Item.Properties().func_200916_a(ModItems.GROUP_SW_ARROWS_BOLTS));
        this.setRegistryName("spartanweaponry", unlocName);
        this.damageModifier = damageModifier;
        this.rangeModifier = rangeModifier;
        this.armorPiercingFactor = armorPiercingFactor;
    }

    public BoltEntity createBolt(World world, ItemStack stack, LivingEntity shooter) {
        BoltEntity bolt = new BoltEntity(shooter, world);
        ItemStack boltStack = stack.func_77946_l();
        boltStack.func_190920_e(1);
        bolt.initEntity(this.damageModifier, this.rangeModifier, this.armorPiercingFactor, boltStack);
        if (bolt.isValid()) {
            return bolt;
        }
        return null;
    }

    public boolean isInfinite(ItemStack stack, ItemStack crossbow, PlayerEntity player) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)crossbow);
        return enchant <= 0 ? false : ((Object)((Object)this)).getClass() == BoltItem.class;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.base_damage", new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.base_damage.value", new Object[]{Float.valueOf(this.damageModifier)}).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.range", new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.range.value", new Object[]{Float.valueOf(this.rangeModifier)}).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.armor_piercing_factor", new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.modifiers.projectile.armor_piercing_factor.value", new Object[]{Float.valueOf(this.armorPiercingFactor * 100.0f)}).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_AQUA));
    }

    public void updateFromConfig(float damageModifier, float rangeModifier, float armorPiercingFactor) {
        this.damageModifier = damageModifier;
        this.rangeModifier = rangeModifier;
        this.armorPiercingFactor = armorPiercingFactor;
    }
}

