/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MissingMappings {
    private static final Map<ResourceLocation, Enchantment> REMAP_VALUES = ImmutableMap.builder().put((Object)new ResourceLocation("spartanweaponry", "throwing_range"), (Object)ModEnchantments.THROWING_RANGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_damage"), (Object)ModEnchantments.THROWING_DAMAGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_fire"), (Object)ModEnchantments.THROWING_FIRE).put((Object)new ResourceLocation("spartanweaponry", "throwing_luck"), (Object)ModEnchantments.THROWING_LUCK).put((Object)new ResourceLocation("spartanweaponry", "throwing_hydrodynamic"), (Object)ModEnchantments.THROWING_HYDRODYNAMIC).put((Object)new ResourceLocation("spartanweaponry", "throwing_charge"), (Object)ModEnchantments.THROWING_CHARGE).put((Object)new ResourceLocation("spartanweaponry", "throwing_ammo"), (Object)ModEnchantments.THROWING_AMMO).build();

    @SubscribeEvent
    public static void onMissingMappings(RegistryEvent.MissingMappings<Enchantment> ev) {
        ImmutableList missingMaps = ev.getMappings("spartanweaponry");
        Log.info("Found missing enchantment mappings! Attempting to correct " + missingMaps.size() + " values!");
        missingMaps.forEach(mapping -> {
            Enchantment replacement = REMAP_VALUES.get(mapping.key);
            if (replacement != null) {
                Log.info("Remapped enchantment " + mapping.key.toString() + " to " + replacement.getRegistryName().toString());
                mapping.remap((IForgeRegistryEntry)replacement);
            }
        });
        Log.info("Remapping complete!");
    }
}

