/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.loot.ModLootTables;
import com.oblivioussp.spartanweaponry.merchant.villager.FletcherTrades;
import com.oblivioussp.spartanweaponry.merchant.villager.WeaponsmithTrades;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    public static Random rand = new Random();

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        DamageSource src = ev.getSource();
        float dmgDealt = ev.getAmount();
        LivingEntity target = ev.getEntityLiving();
        if (dmgDealt == 0.0f || src.func_76352_a() || src.func_76347_k() || src.func_94541_c() || src.func_82725_o() || !src.func_76355_l().equals("player") && !src.func_76355_l().equals("mob")) {
            return;
        }
        if (src.func_76364_f() == src.func_76346_g() && src.func_76346_g() instanceof LivingEntity && target != null) {
            IMeleeTraitCallback callback;
            IWeaponTraitContainer container;
            LivingEntity attacker = (LivingEntity)src.func_76346_g();
            ItemStack attackerStack = attacker.func_184614_ca();
            ItemStack targetStack = target.func_184614_ca();
            if (!attackerStack.func_190926_b() && attackerStack.func_77973_b() instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)attackerStack.func_77973_b();
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                for (WeaponTrait trait : container.getMaterial().getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterial(), dmgDealt, src, attacker, target);
                }
            }
            if (attackerStack.func_77973_b() instanceof ThrowingWeaponItem && attackerStack.func_77942_o() && attackerStack.func_77978_p().func_74762_e("AmmoUsed") >= ((ThrowingWeaponItem)attackerStack.func_77973_b()).getMaxAmmo(attackerStack)) {
                dmgDealt = 1.0f;
            }
            if (!targetStack.func_190926_b() && targetStack.func_77973_b() instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)targetStack.func_77973_b();
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                for (WeaponTrait trait : container.getMaterial().getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterial(), dmgDealt, src, attacker, target);
                }
            }
            if (dmgDealt != ev.getAmount()) {
                if (!attacker.field_70170_p.field_72995_K) {
                    if (dmgDealt > ev.getAmount()) {
                        ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197622_o, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_(), 16, 0.2, 0.2, 0.2, 0.0);
                    } else if (dmgDealt < ev.getAmount()) {
                        ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197601_L, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_(), 16, 0.2, 0.2, 0.2, 0.0);
                    }
                }
                ev.setAmount(dmgDealt);
            }
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent ev) {
        ItemStack activeStack;
        PlayerEntity player;
        if (ev.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)ev.getEntityLiving()).func_184587_cr() && !player.func_184607_cu().func_190926_b() && (activeStack = player.func_184607_cu()).func_77973_b() instanceof SwordBaseItem && ((SwordBaseItem)activeStack.func_77973_b()).hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
            DamageSource source = ev.getSource();
            boolean damageItem = false;
            if (!(source.func_94541_c() || source.func_76347_k() || source.func_82725_o() || source.func_76352_a() || source.func_76363_c())) {
                Entity trueSourceEntity = source.func_76346_g();
                if (trueSourceEntity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)source.func_76346_g();
                    living.func_233627_a_(0.3f, player.func_226277_ct_() - living.func_226277_ct_(), player.func_226281_cx_() - living.func_226281_cx_());
                }
                damageItem = true;
            }
            if (damageItem) {
                int itemDamage = 1 + MathHelper.func_76141_d((float)ev.getAmount());
                activeStack.func_222118_a(itemDamage, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(playerEntity.func_184600_cs()));
                player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 0.8f, 0.8f);
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void modifyLootLevel(LootingLevelEvent ev) {
        if (ev.getDamageSource() == null) {
            return;
        }
        Entity e = ev.getDamageSource().func_76364_f();
        if (e != null && e instanceof ThrowingWeaponEntity) {
            ThrowingWeaponEntity throwingWeapon = (ThrowingWeaponEntity)e;
            int luckLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_LUCK, (ItemStack)throwingWeapon.getWeaponStack());
            ev.setLootingLevel(luckLevel);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        if ((ev.getSlot() == EquipmentSlotType.MAINHAND || ev.getSlot() == EquipmentSlotType.OFFHAND) && ev.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)ev.getEntityLiving();
            ItemStack fromStack = ev.getFrom();
            ItemStack toStack = ev.getTo();
            EquipmentSlotType oppositeHand = ev.getSlot() == EquipmentSlotType.OFFHAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            ItemStack oppositeStack = player.func_184582_a(oppositeHand);
            if (!fromStack.func_77969_a(toStack) && !oppositeStack.func_190926_b()) {
                boolean toStackBlacklisted = false;
                String toName = toStack.func_77973_b().getRegistryName().toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(toName)) {
                    toStackBlacklisted = true;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(fromStack) || quiverInfo.isWeapon(toStack) && !toStackBlacklisted || !quiverInfo.isAmmo(oppositeStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    CommonEventHandler.placeAmmoIntoQuiver(player, quiver, oppositeHand);
                    oppositeStack = player.func_184582_a(oppositeHand);
                    if (!oppositeStack.func_190926_b()) continue;
                    CompoundNBT nbt = quiver.func_179543_a("OffhandMoved");
                    if (nbt == null) break;
                    String itemId = nbt.func_74779_i("Id");
                    int itemSlot = nbt.func_74762_e("Slot");
                    ItemStack offhandStack = player.field_71071_by.func_70301_a(itemSlot);
                    if (offhandStack.func_77973_b().getRegistryName().toString().equals(itemId)) {
                        player.func_184201_a(oppositeHand, offhandStack);
                        player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
                    }
                    quiver.func_77978_p().func_82580_o("OffhandMoved");
                    break;
                }
            }
            if (!toStack.func_77969_a(fromStack)) {
                String regName = toStack.func_77973_b().getRegistryName().toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(regName)) {
                    return;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(toStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    if (!(quiver.func_190926_b() || oppositeStack.func_190926_b() || quiverInfo.isAmmo(oppositeStack))) {
                        int emptySlot = -1;
                        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack playerStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                            if (!playerStack.func_190926_b()) continue;
                            emptySlot = i;
                            break;
                        }
                        if (emptySlot != -1) {
                            String itemId = oppositeStack.func_77973_b().getRegistryName().toString();
                            CompoundNBT nbt = quiver.func_190925_c("OffhandMoved");
                            nbt.func_74778_a("Id", itemId);
                            nbt.func_74768_a("Slot", emptySlot);
                            player.field_71071_by.func_70299_a(emptySlot, oppositeStack);
                            player.func_184201_a(oppositeHand, ItemStack.field_190927_a);
                        }
                    }
                    if (player.func_184582_a(oppositeHand).func_190926_b()) {
                        CommonEventHandler.takeAmmoFromQuiver(player, quiver, oppositeHand);
                    }
                    if ((oppositeStack = player.func_184582_a(oppositeHand)).func_190926_b()) continue;
                    break;
                }
            }
        }
    }

    protected static void placeAmmoIntoQuiver(PlayerEntity player, ItemStack quiver, EquipmentSlotType oppositeHandSlot) {
        if (!quiver.func_190926_b()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
            ItemStack arrowStack = player.func_184582_a(oppositeHandSlot);
            for (int j = 0; j < quiverHandler.getSlots() && !(arrowStack = quiverHandler.insertItem(j, arrowStack, false)).func_190926_b(); ++j) {
            }
            player.func_184201_a(oppositeHandSlot, arrowStack);
        }
    }

    protected static void takeAmmoFromQuiver(PlayerEntity player, ItemStack quiver, EquipmentSlotType oppositeHandSlot) {
        if (!quiver.func_190926_b()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
            ItemStack arrowStack = ItemStack.field_190927_a;
            for (int j = 0; j < quiverHandler.getSlots(); ++j) {
                arrowStack = quiverHandler.extractItem(j, 64, false);
                if (arrowStack.func_190926_b()) continue;
                player.func_184201_a(oppositeHandSlot, arrowStack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickup(EntityItemPickupEvent ev) {
        int beforeCount;
        ItemStack pickedUpStack = ev.getItem().func_92059_d().func_77946_l();
        int afterCount = beforeCount = pickedUpStack.func_190916_E();
        PlayerEntity player = ev.getPlayer();
        List<ItemStack> quivers = QuiverHelper.findValidQuivers(player);
        if (!quivers.isEmpty()) {
            for (ItemStack quiver : quivers) {
                if (!pickedUpStack.func_190926_b() && !quiver.func_190926_b() && ((QuiverBaseItem)quiver.func_77973_b()).isAmmoValid(pickedUpStack, quiver) && quiver.func_196082_o().func_74767_n("ammoCollect")) {
                    IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
                    for (int i = 0; i < quiverHandler.getSlots(); ++i) {
                        pickedUpStack = quiverHandler.insertItem(i, pickedUpStack, false);
                    }
                }
                if (!pickedUpStack.func_190926_b()) continue;
                break;
            }
            if ((afterCount = pickedUpStack.func_190916_E()) < beforeCount) {
                player.func_71001_a((Entity)ev.getItem(), beforeCount - afterCount);
                ev.getItem().func_92059_d().func_190920_e(afterCount);
                player.field_70170_p.func_184148_a((PlayerEntity)null, ev.getItem().func_226277_ct_(), ev.getItem().func_226278_cu_(), ev.getItem().func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
            }
        }
        if (pickedUpStack.func_77973_b() instanceof ThrowingWeaponItem) {
            boolean pickUpAsNewItem = true;
            boolean removeItems = false;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                if (!ItemStack.func_185132_d((ItemStack)slotStack, (ItemStack)pickedUpStack) || !pickedUpStack.func_77942_o() || !slotStack.func_77942_o() || !slotStack.func_77978_p().func_186855_b("UUID") || !pickedUpStack.func_77978_p().func_186855_b("UUID") || !pickedUpStack.func_77978_p().func_186857_a("UUID").equals(slotStack.func_77978_p().func_186857_a("UUID"))) continue;
                int maxAmmo = ((ThrowingWeaponItem)slotStack.func_77973_b()).getMaxAmmo(slotStack);
                int currentAmmo = maxAmmo - slotStack.func_77978_p().func_74762_e("AmmoUsed");
                boolean currentNotOriginalStack = !slotStack.func_77978_p().func_74767_n("Original");
                boolean pickedUpOriginalStack = pickedUpStack.func_77978_p().func_74767_n("Original");
                if (currentAmmo >= maxAmmo && (!currentNotOriginalStack || !pickedUpOriginalStack)) continue;
                int itemDamage = slotStack.func_77952_i() + pickedUpStack.func_77952_i();
                if (itemDamage > slotStack.func_77958_k()) {
                    itemDamage -= slotStack.func_77958_k() + 1;
                } else {
                    currentAmmo += maxAmmo - pickedUpStack.func_77978_p().func_74762_e("AmmoUsed");
                    currentAmmo = MathHelper.func_76125_a((int)currentAmmo, (int)0, (int)maxAmmo);
                    slotStack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - currentAmmo);
                    if (currentNotOriginalStack && pickedUpOriginalStack) {
                        slotStack.func_77978_p().func_74757_a("Original", pickedUpOriginalStack);
                        if (pickedUpStack.func_77948_v()) {
                            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)pickedUpStack);
                            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)slotStack);
                        }
                    }
                }
                slotStack.func_196085_b(itemDamage);
                pickUpAsNewItem = false;
                removeItems = true;
                break;
            }
            if (pickUpAsNewItem) {
                removeItems = player.field_71071_by.func_70441_a(pickedUpStack);
            }
            if (removeItems) {
                player.func_71001_a((Entity)player, 1);
                player.field_70170_p.func_184148_a((PlayerEntity)null, ev.getItem().func_226277_ct_(), ev.getItem().func_226278_cu_(), ev.getItem().func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
                ev.getItem().func_92059_d().func_190920_e(0);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent ev) {
        if (((Boolean)Config.INSTANCE.addIronWeaponsToVillageWeaponsmith.get()).booleanValue() && ev.getName().equals((Object)LootTables.field_215814_e)) {
            Log.info("Adding Iron Weapons to the Village Weaponsmith Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_VILLAGE_WEAPONSMITH));
        } else if (((Boolean)Config.INSTANCE.addBowAndCrossbowLootToVillageFletcher.get()).booleanValue() && ev.getName().equals((Object)LootTables.field_215821_l)) {
            Log.info("Adding Longbow and Heavy Crossbow related loot to the Village Fletcher Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_VILLAGE_FLETCHER));
        } else if (((Boolean)Config.INSTANCE.addDiamondWeaponsToEndCity.get()).booleanValue() && ev.getName().equals((Object)LootTables.field_186421_c)) {
            Log.info("Adding Diamond Weapons to the End City Treasure Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool(ModLootTables.INJECT_END_CITY_TREASURE));
        }
    }

    private static LootPool generateLootPool(ResourceLocation lootName) {
        return LootPool.func_216096_a().func_216045_a(CommonEventHandler.generateLootEntry(lootName)).bonusRolls(0.0f, 1.0f).name("spartanweaponry_inject").func_216044_b();
    }

    private static LootEntry.Builder<?> generateLootEntry(ResourceLocation lootName) {
        return TableLootEntry.func_216171_a((ResourceLocation)lootName).func_216086_a(1);
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent ev) {
        if (((Boolean)Config.INSTANCE.disableSpawningZombieWithWeapon.get()).booleanValue() && ev.getEntity() instanceof ZombieEntity) {
            float chance;
            ZombieEntity entity = (ZombieEntity)ev.getEntity();
            float rand = entity.field_70170_p.field_73012_v.nextFloat();
            float f = chance = entity.field_70170_p.func_175659_aa() == Difficulty.HARD ? ((Double)Config.INSTANCE.zombieWithMeleeSpawnChanceHard.get()).floatValue() : ((Double)Config.INSTANCE.zombieWithMeleeSpawnChanceNormal.get()).floatValue();
            if (rand > 1.0f - chance) {
                ItemStack weapon = ItemStack.field_190927_a;
                Item[] possibleWeapons = new Item[]{ModItems.daggers.iron, ModItems.longswords.iron, ModItems.katanas.iron, ModItems.sabers.iron, ModItems.rapiers.iron, ModItems.greatswords.iron, ModItems.battleHammers.iron, ModItems.warhammers.iron, ModItems.battleaxes.iron, ModItems.flangedMaces.iron};
                weapon = CommonEventHandler.generateRandomItem(entity.field_70170_p, possibleWeapons);
                entity.func_184201_a(EquipmentSlotType.MAINHAND, weapon);
            }
        }
    }

    private static ItemStack generateRandomItem(World world, Item[] items) {
        float divider;
        float weaponRand = world.field_73012_v.nextFloat();
        int idx = MathHelper.func_76141_d((float)(weaponRand / (divider = 1.0f / (float)items.length)));
        idx = idx > items.length - 1 ? items.length - 1 : idx;
        return new ItemStack((IItemProvider)items[idx]);
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent ev) {
        if (((Boolean)Config.INSTANCE.disableVillagerTrading.get()).booleanValue()) {
            return;
        }
        if (ev.getType() == VillagerProfession.field_221165_o) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv2 = (List)ev.getTrades().get(2);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv4 = (List)ev.getTrades().get(4);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!WeaponsmithTrades.LVL1_ITEMS.isEmpty()) {
                tradesLv1.add(WeaponsmithTrades.LVL1_TRADE);
            }
            if (!WeaponsmithTrades.LVL2_ITEMS.isEmpty()) {
                tradesLv2.add(WeaponsmithTrades.LVL2_TRADE);
            }
            if (!WeaponsmithTrades.LVL3_ITEMS.isEmpty()) {
                tradesLv3.add(WeaponsmithTrades.LVL3_TRADE);
            }
            if (!WeaponsmithTrades.LVL4_ITEMS.isEmpty()) {
                tradesLv4.add(WeaponsmithTrades.LVL4_TRADE);
            }
            if (!WeaponsmithTrades.LVL5_ITEMS.isEmpty()) {
                tradesLv5.add(WeaponsmithTrades.LVL5_TRADE);
            }
        } else if (ev.getType() == VillagerProfession.field_221158_h) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv1.add(FletcherTrades.LONGBOW_WOOD_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.LONGBOW_IRON_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.HEAVY_CROSSBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.BOLT_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_LONGBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_HEAVY_CROSSBOW_TRADE);
            }
        }
    }

    @SubscribeEvent
    public static void handleAnvilUpdate(AnvilUpdateEvent ev) {
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.func_77973_b() instanceof ThrowingWeaponItem && left.func_77942_o() && left.func_77978_p().func_74767_n("Original") && left.func_185136_b(right)) {
            ThrowingWeaponItem throwingWeapon = (ThrowingWeaponItem)left.func_77973_b();
            int leftAmmo = left.func_77978_p().func_74762_e("AmmoUsed");
            int rightAmmo = right.func_77978_p().func_74762_e("AmmoUsed");
            if (leftAmmo == 0) {
                return;
            }
            int maxAmmo = ((ThrowingWeaponItem)left.func_77973_b()).getMaxAmmo(left);
            int durability = left.func_77952_i() + right.func_77952_i();
            int combinedAmmo = MathHelper.func_76125_a((int)(maxAmmo - leftAmmo + (maxAmmo - rightAmmo)), (int)0, (int)throwingWeapon.getMaxAmmo(left));
            if (durability > left.func_77958_k()) {
                combinedAmmo = Math.max(combinedAmmo - 1, 0);
                durability -= left.func_77958_k();
            }
            ItemStack resultStack = ev.getLeft().func_77946_l();
            resultStack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - combinedAmmo);
            resultStack.func_196085_b(durability);
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)left);
            int cost = 1;
            for (Map.Entry enchantment : enchantmentMap.entrySet()) {
                cost += ((Integer)enchantment.getValue()).intValue();
            }
            ev.setCost(cost);
            ev.setOutput(resultStack);
        }
    }
}

