/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.api.APIAttributes;
import com.oblivioussp.spartanweaponry.client.KeyBinds;
import com.oblivioussp.spartanweaponry.network.KeyHandlePacket;
import com.oblivioussp.spartanweaponry.network.LongReachAttackPacket;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onMouseEvent(InputEvent.MouseInputEvent ev) {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71462_r != null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (ev.getButton() == keyAttack.getKey().func_197937_c() && ev.getAction() == 1) {
            ClientEventHandler.checkForReachAttack();
        }
        if (ev.getButton() == KeyBinds.KEY_ACCESS_QUIVER.getKey().func_197937_c() && ev.getAction() == 1) {
            NetworkHandler.sendPacketToServer(new KeyHandlePacket());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onKeyEvent(InputEvent.KeyInputEvent ev) {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71462_r != null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (ev.getKey() == keyAttack.getKey().func_197937_c() && ev.getAction() == 1) {
            ClientEventHandler.checkForReachAttack();
        }
        if (ev.getKey() == KeyBinds.KEY_ACCESS_QUIVER.getKey().func_197937_c() && ev.getAction() == 1) {
            NetworkHandler.sendPacketToServer(new KeyHandlePacket());
        }
    }

    private static void checkForReachAttack() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || player.func_184585_cz()) {
            return;
        }
        double reach = (float)player.func_233637_b_(APIAttributes.ATTACK_REACH);
        if (reach == APIAttributes.ATTACK_REACH.func_111110_b()) {
            return;
        }
        RayTraceResult rayTrace = ClientEventHandler.getEntityMouseOverExtended((float)reach);
        if (!(rayTrace instanceof EntityRayTraceResult)) {
            return;
        }
        EntityRayTraceResult entityRayTrace = (EntityRayTraceResult)rayTrace;
        Entity entityHit = entityRayTrace.func_216348_a();
        if (entityHit != null && entityHit.field_70172_ad == 0 && entityHit != player && entityHit != player.func_184187_bx()) {
            float velocity = 0.0f;
            if (player.func_184187_bx() != null) {
                Entity riding = player.func_184187_bx();
                Vector3d vec = riding.func_213322_ci();
                velocity = (float)vec.func_72433_c();
            }
            NetworkHandler.sendPacketToServer(new LongReachAttackPacket(entityHit.func_145782_y(), velocity));
            Log.debug("Long Reach Packet sent!");
        }
    }

    private static RayTraceResult getEntityMouseOverExtended(float reach) {
        BlockRayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity != null) {
            AxisAlignedBB expBounds;
            double d0 = reach;
            RayTraceResult rayTrace = viewEntity.func_213324_a(d0, 0.0f, false);
            Vector3d eyePos = viewEntity.func_174824_e(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.field_71442_b.func_78749_i() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)reach) {
                flag = true;
            }
            d1 *= d1;
            if (rayTrace != null) {
                d1 = rayTrace.func_216347_e().func_72436_e(eyePos);
            }
            Vector3d lookVec = viewEntity.func_70676_i(1.0f);
            Vector3d attackVec = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
            EntityRayTraceResult entityRayTrace = ProjectileHelper.func_221273_a((Entity)viewEntity, (Vector3d)eyePos, (Vector3d)attackVec, (AxisAlignedBB)(expBounds = viewEntity.func_174813_aQ().func_216361_a(lookVec.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)d1);
            if (entityRayTrace != null) {
                Vector3d hitVec = entityRayTrace.func_216347_e();
                double d2 = eyePos.func_72436_e(hitVec);
                if (flag && d2 > (double)(reach * reach)) {
                    result = BlockRayTraceResult.func_216352_a((Vector3d)hitVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(hitVec));
                } else if (d2 < d1 || result == null) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockRayTraceResult.func_216352_a((Vector3d)attackVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(attackVec));
            }
        }
        return result;
    }
}

