/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrowingWeaponEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String NBT_WEAPON = "Weapon";
    protected static final DataParameter<ItemStack> DATA_WEAPON = EntityDataManager.func_187226_a(ThrowingWeaponEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Byte> DATA_RETURN = EntityDataManager.func_187226_a(ThrowingWeaponEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected int ticksInAir = 0;
    protected float waterDrag = 0.0f;
    protected boolean isReturning = false;
    protected boolean playedReturnSound = false;

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, World world) {
        super(type, world);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, World world, double x, double y, double z) {
        super(type, x, y, z, world);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, LivingEntity shooter, World world) {
        super(type, shooter, world);
    }

    public ThrowingWeaponEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.THROWING_WEAPON, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_WEAPON, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(DATA_RETURN, (Object)0);
    }

    protected ItemStack func_184550_j() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_WEAPON);
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public void func_70071_h_() {
        byte returnLevel;
        if (this.waterDrag == 0.0f) {
            this.waterDrag = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_HYDRODYNAMIC, (ItemStack)this.getWeaponStack()) == 1 ? 0.98f : -1.0f;
        }
        Entity thrower = this.func_234616_v_();
        if ((this.field_184552_b > 4 || this.isReturning) && thrower != null && (returnLevel = ((Byte)this.func_184212_Q().func_187225_a(DATA_RETURN)).byteValue()) > 0) {
            if (!(thrower == null || !thrower.func_70089_S() || thrower instanceof ServerPlayerEntity && thrower.func_175149_v())) {
                if (!this.isReturning) {
                    this.func_203045_n(true);
                    this.field_70254_i = false;
                    this.isReturning = true;
                    this.func_189654_d(true);
                }
                Vector3d distance = new Vector3d(thrower.func_226277_ct_() - this.func_226277_ct_(), thrower.func_226280_cw_() - this.func_226278_cu_(), thrower.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + distance.field_72448_b * 0.015 * (double)returnLevel, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double velocity = 1.0 + 0.25 * (double)returnLevel;
                this.func_213317_d(distance.func_72432_b().func_186678_a(velocity));
                if (!this.playedReturnSound) {
                    this.func_184185_a(ModSounds.THROWING_WEAPON_LOYALTY_RETURN, 10.0f, 1.0f);
                    this.playedReturnSound = true;
                }
            } else if (returnLevel > 0 && !thrower.func_70089_S()) {
                this.func_203045_n(false);
                this.isReturning = false;
                this.func_189654_d(false);
                this.func_184212_Q().func_187227_b(DATA_RETURN, (Object)0);
            }
        }
        super.func_70071_h_();
        if (!this.field_70254_i) {
            ++this.ticksInAir;
        } else if (this.ticksInAir != 0) {
            this.ticksInAir = 0;
        }
    }

    protected void func_225516_i_() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.dropAsItem();
            this.func_70106_y();
        }
    }

    public int func_82145_z() {
        return 100;
    }

    protected void func_213868_a(EntityRayTraceResult rayTrace) {
        Entity entity = rayTrace.func_216348_a();
        Entity shooter = this.func_234616_v_();
        if (entity != null) {
            ItemStack weapon = this.getWeaponStack();
            float damage = MathHelper.func_76143_f((double)this.func_70242_d());
            if (this.func_70241_g()) {
                damage += (float)this.field_70146_Z.nextInt((int)damage / 2 + 2);
            }
            if (shooter != null && (this.canBeCaughtInMidair(shooter, entity) || this.isReturning) && entity instanceof PlayerEntity && this.attemptCatch((PlayerEntity)entity)) {
                return;
            }
            DamageSource src = shooter == null ? new IndirectEntityDamageSource("mob", (Entity)this, (Entity)this).func_76349_b() : (shooter instanceof PlayerEntity ? new IndirectEntityDamageSource("player", (Entity)this, shooter).func_76349_b() : new IndirectEntityDamageSource("mob", (Entity)this, shooter).func_76349_b());
            if (weapon.func_77973_b() instanceof IWeaponTraitContainer && entity instanceof LivingEntity && shooter instanceof LivingEntity && !entity.func_70028_i(shooter)) {
                IMeleeTraitCallback callback;
                IWeaponTraitContainer container = (IWeaponTraitContainer)weapon.func_77973_b();
                WeaponMaterial material = container.getMaterial();
                List<WeaponTrait> traits = container.getAllWeaponTraits();
                for (WeaponTrait trait : traits) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(material, damage, src, (LivingEntity)shooter, (LivingEntity)entity);
                    callback.onHitEntity(container.getMaterial(), weapon, (LivingEntity)entity, (LivingEntity)shooter, (Entity)this);
                }
                for (WeaponTrait prop : material.getAllWeaponTraits()) {
                    callback = prop.getMeleeCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(material, damage, src, (LivingEntity)shooter, (LivingEntity)entity);
                    callback.onHitEntity(material, weapon, (LivingEntity)entity, (LivingEntity)shooter, (Entity)this);
                }
            }
            if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(src, damage)) {
                if (weapon.func_77984_f() && weapon.func_96631_a(1, this.field_70146_Z, null)) {
                    this.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                    this.func_70106_y();
                }
                if (entity instanceof LivingEntity) {
                    Vector3d knockVec;
                    LivingEntity entitylivingbase = (LivingEntity)entity;
                    if (this.field_70256_ap > 0 && (knockVec = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                        entitylivingbase.func_70024_g(knockVec.field_72450_a, 0.1, knockVec.field_72449_c);
                    }
                    if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)entitylivingbase, (Entity)shooter);
                        EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (shooter != null && entitylivingbase != shooter && entitylivingbase instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                    }
                }
                this.func_184185_a(this.getMobHitSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EndermanEntity)) {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                }
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                    if ((Byte)this.func_184212_Q().func_187225_a(DATA_RETURN) > 0 && !this.func_203047_q()) {
                        this.func_203045_n(true);
                    } else if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                        this.dropAsItem();
                    }
                    this.func_70106_y();
                }
            }
        } else {
            super.func_213868_a(rayTrace);
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (!this.field_70170_p.field_72995_K) {
                BlockState state = this.field_70170_p.func_180495_p(result.func_216350_a());
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state).setPos(result.func_216350_a()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            ItemStack stack = this.getWeaponStack();
            this.removeEnchantments(stack);
        }
        super.func_230299_a_(result);
    }

    protected void removeEnchantments(ItemStack stack) {
        if (stack.func_77948_v() && stack.func_196082_o().func_74764_b("AmmoUsed")) {
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of(), (ItemStack)stack);
            if (!this.field_70170_p.field_72995_K) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10, 0.1, 0.1, 0.1, 0.2);
            }
        }
    }

    protected void dropAsItem() {
        ItemStack stack = this.func_184550_j();
        this.removeEnchantments(stack);
        this.func_70099_a(stack, 0.1f);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.field_70254_i || this.isReturning) {
            this.attemptCatch(entityIn);
        }
    }

    protected float func_203044_p() {
        return this.waterDrag > 0.0f ? this.waterDrag : super.func_203044_p();
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.field_70256_ap = knockbackStrengthIn;
    }

    protected SoundEvent func_213867_k() {
        return this.getGroundHitSound();
    }

    protected SoundEvent getGroundHitSound() {
        return ModSounds.THROWING_KNIFE_HIT_GROUND;
    }

    protected SoundEvent getMobHitSound() {
        return ModSounds.THROWING_KNIFE_HIT_MOB;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeItemStack(this.getWeaponStack(), false);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setWeapon(additionalData.func_150791_c());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getWeaponStack() {
        return this.func_184550_j();
    }

    public boolean isValidThrowingWeapon() {
        return !this.getWeaponStack().func_190926_b();
    }

    public void setWeapon(ItemStack weaponStack) {
        ItemStack stack = weaponStack.func_77946_l();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ThrowingWeaponItem) {
            int maxAmmo = ((ThrowingWeaponItem)stack.func_77973_b()).getMaxAmmo(stack);
            stack.func_196082_o().func_74768_a("AmmoUsed", maxAmmo - 1);
            stack.func_77978_p().func_74757_a("Original", false);
        }
        this.func_184212_Q().func_187227_b(DATA_WEAPON, (Object)stack);
        this.func_184212_Q().func_187227_b(DATA_RETURN, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)stack)));
    }

    protected boolean attemptCatch(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && this.field_70249_b <= 0) {
            boolean canBePickedUp;
            boolean bl = canBePickedUp = this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED || this.field_70251_a == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                boolean pickUpAsNewItem = true;
                ItemStack weapon = this.getWeaponStack();
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    int maxAmmo;
                    int currentAmmo;
                    ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                    if (slotStack.func_77973_b() != weapon.func_77973_b() || !weapon.func_196082_o().func_186855_b("UUID") || !slotStack.func_196082_o().func_186855_b("UUID") || !weapon.func_77978_p().func_186857_a("UUID").equals(slotStack.func_77978_p().func_186857_a("UUID")) || !(weapon.func_77973_b() instanceof ThrowingWeaponItem) || (currentAmmo = (maxAmmo = ((ThrowingWeaponItem)slotStack.func_77973_b()).getMaxAmmo(slotStack)) - slotStack.func_77978_p().func_74762_e("AmmoUsed")) >= maxAmmo) continue;
                    int itemDamage = slotStack.func_77952_i() + weapon.func_77952_i();
                    if (itemDamage > slotStack.func_77958_k()) {
                        itemDamage -= slotStack.func_77958_k() + 1;
                    } else {
                        slotStack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - ++currentAmmo);
                    }
                    slotStack.func_196085_b(itemDamage);
                    pickUpAsNewItem = false;
                    canBePickedUp = true;
                    break;
                }
                if (pickUpAsNewItem) {
                    ItemStack pickUpStack = weapon.func_77946_l();
                    this.removeEnchantments(pickUpStack);
                    canBePickedUp = player.field_71071_by.func_70441_a(pickUpStack);
                }
            }
            if (canBePickedUp) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
            return canBePickedUp;
        }
        return false;
    }

    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter == entityHit && this.field_70145_X;
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }
}

