/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.data;

import com.oblivioussp.spartanweaponry.api.data.BaseModels;
import com.oblivioussp.spartanweaponry.api.data.ModelGenerator;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        ModelGenerator generator = new ModelGenerator(this);
        generator.createSimpleModel(ModItems.handle);
        generator.createSimpleModel(ModItems.pole, BaseModels.basePole);
        generator.createSimpleModel(ModItems.explosiveCharge);
        for (Item dagger : ModItems.daggers.getAsList()) {
            generator.createDaggerModels(dagger);
        }
        for (Item parryingDagger : ModItems.parryingDaggers.getAsList()) {
            generator.createParryingDaggerModels(parryingDagger);
        }
        for (Item longsword : ModItems.longswords.getAsList()) {
            generator.createLongswordModel(longsword);
        }
        for (Item katana : ModItems.katanas.getAsList()) {
            generator.createKatanaModel(katana);
        }
        for (Item saber : ModItems.sabers.getAsList()) {
            generator.createSaberModel(saber);
        }
        for (Item rapiers : ModItems.rapiers.getAsList()) {
            generator.createRapierModel(rapiers);
        }
        for (Item greatsword : ModItems.greatswords.getAsList()) {
            generator.createGreatswordModel(greatsword);
        }
        generator.createClubModel(ModItems.clubWood);
        generator.createClubModel(ModItems.clubStudded);
        generator.createCestusModel(ModItems.cestus);
        generator.createCestusModel(ModItems.cestusStudded);
        for (Item battleHammer : ModItems.battleHammers.getAsList()) {
            generator.createBattleHammerModel(battleHammer);
        }
        for (Item warhammer : ModItems.warhammers.getAsList()) {
            generator.createWarhammerModel(warhammer);
        }
        for (Item spear : ModItems.spears.getAsList()) {
            generator.createSpearModel(spear);
        }
        for (Item halberd : ModItems.halberds.getAsList()) {
            generator.createHalberdModel(halberd);
        }
        for (Item pike : ModItems.pikes.getAsList()) {
            generator.createPikeModel(pike);
        }
        for (Item lance : ModItems.lances.getAsList()) {
            generator.createLanceModel(lance);
        }
        for (Item longbow : ModItems.longbows.getAsList()) {
            generator.createLongbowModels(longbow);
        }
        for (Item heavyCrossbow : ModItems.heavyCrossbows.getAsList()) {
            generator.createHeavyCrossbowModels(heavyCrossbow);
        }
        for (Item throwingKnife : ModItems.throwingKnives.getAsList()) {
            generator.createThrowingKnifeModels(throwingKnife);
        }
        for (Item tomahawk : ModItems.tomahawks.getAsList()) {
            generator.createTomahawkModels(tomahawk);
        }
        for (Item javelin : ModItems.javelins.getAsList()) {
            generator.createJavelinModels(javelin);
        }
        for (Item boomerang : ModItems.boomerangs.getAsList()) {
            generator.createBoomerangModels(boomerang);
        }
        for (Item battleaxe : ModItems.battleaxes.getAsList()) {
            generator.createBattleaxeModel(battleaxe);
        }
        for (Item flangedMace : ModItems.flangedMaces.getAsList()) {
            generator.createFlangedMaceModel(flangedMace);
        }
        for (Item glaive : ModItems.glaives.getAsList()) {
            generator.createGlaiveModel(glaive);
        }
        for (Item quarterstaff : ModItems.quarterstaves.getAsList()) {
            generator.createQuarterstaffModel(quarterstaff);
        }
        for (Item scythe : ModItems.scythes.getAsList()) {
            generator.createScytheModel(scythe);
        }
        generator.createSimpleModel((Item)ModItems.arrowWood);
        this.createTippedArrowModel((Item)ModItems.tippedArrowWood);
        generator.createSimpleModel((Item)ModItems.arrowIron);
        this.createTippedArrowModel((Item)ModItems.tippedArrowIron);
        generator.createSimpleModel((Item)ModItems.arrowDiamond);
        this.createTippedArrowModel((Item)ModItems.tippedArrowDiamond);
        generator.createSimpleModel(ModItems.arrowExplosive);
        generator.createSimpleModel(ModItems.bolt);
        this.createTippedBoltModel(ModItems.tippedBolt);
        generator.createSimpleModel(ModItems.spectralBolt);
        generator.createSimpleModel(ModItems.boltDiamond);
        this.createTippedBoltModel(ModItems.tippedBoltDiamond);
        this.createQuiverModels(ModItems.quiverArrowSmall, 3);
        this.createQuiverModels(ModItems.quiverArrowMedium, 3);
        this.createQuiverModels(ModItems.quiverArrowLarge, 5);
        this.createQuiverModels(ModItems.quiverArrowHuge, 5);
        this.createQuiverModels(ModItems.quiverBoltSmall, 3);
        this.createQuiverModels(ModItems.quiverBoltMedium, 3);
        this.createQuiverModels(ModItems.quiverBoltLarge, 5);
        this.createQuiverModels(ModItems.quiverBoltHuge, 5);
        generator.createSimpleModel(ModItems.quiverUpgradeKitMedium);
        generator.createSimpleModel(ModItems.quiverUpgradeKitLarge);
        generator.createSimpleModel(ModItems.quiverUpgradeKitHuge);
        generator.createSimpleModel(ModItems.dynamite);
    }

    protected ResourceLocation createTippedArrowModel(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base")).texture("layer1", "item/arrow_tipped_head")).getLocation();
    }

    protected ResourceLocation createTippedBoltModel(Item item) {
        String itemPath = item.getRegistryName().func_110623_a();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base")).texture("layer1", "item/bolt_tipped_head")).getLocation();
    }

    protected ResourceLocation createQuiverModels(Item item, int variantCount) {
        String itemPath = item.getRegistryName().func_110623_a();
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (int i = 0; i < variantCount; ++i) {
            String modelVariant = itemPath + "_" + Integer.toString(i + 1);
            variants.add(((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(modelVariant, this.mcLoc("item/generated"))).texture("layer0", "item/" + modelVariant)).getLocation());
        }
        ItemModelBuilder modelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base");
        for (int j = 0; j < variants.size(); ++j) {
            modelBuilder.override().predicate(new ResourceLocation("arrow"), (float)(j + 1)).model((ModelFile)new ModelFile.ExistingModelFile((ResourceLocation)variants.get(j), this.existingFileHelper)).end();
        }
        return modelBuilder.getLocation();
    }

    public String func_200397_b() {
        return "Spartan Weaponry Models";
    }
}

