/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class HudElement {
    protected int width;
    protected int height;

    public int getAlignedX(AlignmentHelper.Alignment align, int offset) {
        int scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        switch (align) {
            case TOP_LEFT: 
            case CENTER_LEFT: 
            case BOTTOM_LEFT: {
                return offset;
            }
            case TOP_CENTER: 
            case CENTER: 
            case BOTTOM_CENTER: {
                return scaledWidth / 2 - this.width / 2 + offset;
            }
            case TOP_RIGHT: 
            case CENTER_RIGHT: 
            case BOTTOM_RIGHT: {
                return scaledWidth - this.width + offset;
            }
        }
        return 0;
    }

    public int getAlignedY(AlignmentHelper.Alignment align, int offset) {
        int scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        switch (align) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                return offset;
            }
            case CENTER_LEFT: 
            case CENTER_RIGHT: {
                return scaledHeight / 2 - this.height / 2 + offset;
            }
            case CENTER: {
                return scaledHeight / 2 - this.height / 2 + 26 + offset;
            }
            case BOTTOM_CENTER: {
                return scaledHeight - this.height - 65 + offset;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return scaledHeight - this.height + offset;
            }
        }
        return 0;
    }

    public HudElement(int elementWidth, int elementHeight) {
        this.width = elementWidth;
        this.height = elementHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void render(MatrixStack var1, float var2);
}

