/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.MeleeCallbackWeaponTrait;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TwoHandedWeaponTrait
extends MeleeCallbackWeaponTrait {
    public TwoHandedWeaponTrait(String type, String modId, int level, float magnitude) {
        super(type, modId, level, magnitude, WeaponTrait.TraitQuality.NEGATIVE);
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.trait.%s.desc", this.modId, this.type), new Object[]{Float.valueOf(this.magnitude * 100.0f)}).func_240701_a_(WeaponTrait.DESCRIPTION_COLOUR)));
    }

    @Override
    public void onItemUpdate(WeaponMaterial material, ItemStack stack, World world, LivingEntity entity, int itemSlot, boolean isSelected) {
        ItemStack mainHand = entity.func_184614_ca();
        ItemStack offHand = entity.func_184592_cb();
        EffectInstance effect = entity.func_70660_b(Effects.field_76419_f);
        if (isSelected && ItemStack.func_185132_d((ItemStack)stack, (ItemStack)mainHand) && !offHand.func_190926_b()) {
            if (effect == null || effect.func_76459_b() <= 1) {
                entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 20, this.level == 2 ? 3 : 2, false, false));
            }
        } else if (effect != null && effect.func_76459_b() <= 0) {
            entity.func_195063_d(Effects.field_76419_f);
        }
    }

    @Override
    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        float resultDamage = baseDamage;
        ItemStack mainHand = attacker.func_184614_ca();
        ItemStack offHand = attacker.func_184592_cb();
        if (!mainHand.func_190926_b() && !offHand.func_190926_b()) {
            resultDamage *= 1.0f - this.magnitude;
        }
        return resultDamage;
    }
}

