/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConditionalShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionalShapelessRecipeBuilder(IItemProvider resultIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public static ConditionalShapelessRecipeBuilder shapelessRecipe(IItemProvider itemIn) {
        return new ConditionalShapelessRecipeBuilder(itemIn, 1);
    }

    public static ConditionalShapelessRecipeBuilder shapelessRecipe(IItemProvider itemIn, int countIn) {
        return new ConditionalShapelessRecipeBuilder(itemIn, countIn);
    }

    public ConditionalShapelessRecipeBuilder addIngredient(ITag<Item> tagIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn));
    }

    public ConditionalShapelessRecipeBuilder addIngredient(ITag<Item> tagIn, int countIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn), countIn);
    }

    public ConditionalShapelessRecipeBuilder addIngredient(IItemProvider itemIn) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public ConditionalShapelessRecipeBuilder addIngredient(IItemProvider itemIn, int countIn) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}), countIn);
    }

    public ConditionalShapelessRecipeBuilder addIngredient(Ingredient ingredientIn) {
        this.ingredients.add(ingredientIn);
        return this;
    }

    public ConditionalShapelessRecipeBuilder addIngredient(Ingredient ingredientIn, int countIn) {
        for (int i = 0; i < countIn; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public ConditionalShapelessRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public ConditionalShapelessRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public ConditionalShapelessRecipeBuilder addCondition(ICondition conditionIn) {
        this.conditions.add(conditionIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation resultLoc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (saveLoc.equals((Object)resultLoc)) {
            throw new IllegalStateException("Shaped recipe " + save + " save argument is redundant as it's the same as the item id!");
        }
        this.build(consumerIn, saveLoc);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("minecraft:recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.conditions, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("Impossible to obtain recipe " + id + "!");
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final List<ICondition> conditions;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, List<ICondition> conditionsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.ingredients = ingredientsIn;
            this.conditions = conditionsIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultJson);
            JsonArray conditionArray = new JsonArray();
            for (ICondition condition : this.conditions) {
                conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)conditionArray);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

