/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConditionalShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> keys = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionalShapedRecipeBuilder(IItemProvider resultIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public static ConditionalShapedRecipeBuilder shapedRecipe(IItemProvider itemIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, 1);
    }

    public static ConditionalShapedRecipeBuilder shapedRecipe(IItemProvider itemIn, int countIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, countIn);
    }

    public ConditionalShapedRecipeBuilder key(Character character, ITag<Item> tagIn) {
        return this.key(character, Ingredient.func_199805_a(tagIn));
    }

    public ConditionalShapedRecipeBuilder key(Character character, IItemProvider itemIn) {
        return this.key(character, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public ConditionalShapedRecipeBuilder key(Character character, Ingredient ingredientIn) {
        if (this.keys.containsKey(character)) {
            throw new IllegalArgumentException("Key character '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Key character ' ' (whitespace) cannot be defined as it is reserved!");
        }
        this.keys.put(character, ingredientIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder patternLine(String patternIn) {
        if (patternIn.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public ConditionalShapedRecipeBuilder addCondition(ICondition conditionIn) {
        this.conditions.add(conditionIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation resultLoc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (saveLoc.equals((Object)resultLoc)) {
            throw new IllegalStateException("Shaped recipe " + save + " save argument is redundant as it's the same as the item id!");
        }
        this.build(consumerIn, saveLoc);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("minecraft:recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.keys, this.conditions, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern was defined for recipe " + id + "!");
        }
        HashSet<Character> characters = new HashSet<Character>(this.keys.keySet());
        characters.remove(Character.valueOf(' '));
        for (int iS = 0; iS < this.pattern.size(); ++iS) {
            String s = this.pattern.get(iS);
            if (s.length() != this.pattern.get(0).length()) {
                throw new IllegalStateException("Pattern rows in recipe " + id + " must be the same length! Expected row size " + this.pattern.get(0).length() + "; got " + s.length() + " on row " + iS);
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (!this.keys.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses an undefined key '" + c + "' in location " + iS + ", " + i);
                }
                characters.remove(Character.valueOf(c));
            }
        }
        if (!characters.isEmpty()) {
            throw new IllegalStateException("Defined ingredients are not used in recipe " + id + "!");
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Single item only defined in shaped recipe " + id + "! Use a shapeless recipe instead!");
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("Impossible to obtain recipe " + id + "!");
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> keys;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final List<ICondition> conditions;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<String> patternIn, Map<Character, Ingredient> keyIn, List<ICondition> conditionsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.pattern = patternIn;
            this.keys = keyIn;
            this.conditions = conditionsIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            json.add("pattern", (JsonElement)patternArray);
            JsonObject keysJson = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.keys.entrySet()) {
                keysJson.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)keysJson);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            JsonArray jsonArray = new JsonArray();
            for (ICondition condition : this.conditions) {
                jsonArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)jsonArray);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

