/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.lucko.fabric.api.permissions.v0.Permissions;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.platform.MetadataProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.fabric.FabricCommandSender;
import me.lucko.spark.fabric.FabricExtraMetadataProvider;
import me.lucko.spark.fabric.FabricPlatformInfo;
import me.lucko.spark.fabric.FabricPlayerPingProvider;
import me.lucko.spark.fabric.FabricServerConfigProvider;
import me.lucko.spark.fabric.FabricSparkMod;
import me.lucko.spark.fabric.FabricTickHook;
import me.lucko.spark.fabric.FabricTickReporter;
import me.lucko.spark.fabric.FabricWorldInfoProvider;
import me.lucko.spark.fabric.placeholder.SparkFabricPlaceholderApi;
import me.lucko.spark.fabric.plugin.FabricSparkPlugin;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class FabricServerSparkPlugin
extends FabricSparkPlugin
implements Command<class_2168>,
SuggestionProvider<class_2168> {
    private final MinecraftServer server;
    private final ThreadDumper gameThreadDumper;

    public static FabricServerSparkPlugin register(FabricSparkMod mod, MinecraftServer server) {
        FabricServerSparkPlugin plugin = new FabricServerSparkPlugin(mod, server);
        plugin.enable();
        return plugin;
    }

    public FabricServerSparkPlugin(FabricSparkMod mod, MinecraftServer server) {
        super(mod);
        this.server = server;
        this.gameThreadDumper = new ThreadDumper.Specific(server.method_3777());
    }

    @Override
    public void enable() {
        super.enable();
        this.registerCommands((CommandDispatcher<class_2168>)this.server.method_3734().method_9235());
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            try {
                SparkFabricPlaceholderApi.register(this.platform);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        FabricServerSparkPlugin.registerCommands(dispatcher, this, this, "spark");
    }

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        String[] args = FabricServerSparkPlugin.processArgs(context, false, "/spark", "spark");
        if (args == null) {
            return 0;
        }
        class_1297 source = ((class_2168)context.getSource()).method_9228() != null ? ((class_2168)context.getSource()).method_9228() : ((class_2168)context.getSource()).method_9211();
        this.platform.executeCommand(new FabricCommandSender((class_2165)source, this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = FabricServerSparkPlugin.processArgs(context, true, "/spark", "spark");
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new FabricCommandSender((class_2165)((class_2168)context.getSource()).method_44023(), this), args, builder);
    }

    @Override
    public boolean hasPermission(class_2165 sender, String permission) {
        if (sender instanceof class_1657) {
            class_1657 player = (class_1657)sender;
            return Permissions.getPermissionValue((class_1297)player, (String)permission).orElseGet(() -> {
                MinecraftServer server = player.method_5682();
                if (server != null && server.method_19466(player.method_7334())) {
                    return true;
                }
                return player.method_5687(4);
            });
        }
        return true;
    }

    public Stream<FabricCommandSender> getCommandSenders() {
        return Stream.concat(this.server.method_3760().method_14571().stream(), Stream.of(this.server)).map(sender -> new FabricCommandSender((class_2165)sender, this));
    }

    @Override
    public void executeSync(Runnable task) {
        this.server.method_40000(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    @Override
    public TickHook createTickHook() {
        return new FabricTickHook.Server();
    }

    @Override
    public TickReporter createTickReporter() {
        return new FabricTickReporter.Server();
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new FabricPlayerPingProvider(this.server);
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return new FabricServerConfigProvider();
    }

    @Override
    public MetadataProvider createExtraMetadataProvider() {
        return new FabricExtraMetadataProvider(this.server.method_3836());
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new FabricWorldInfoProvider.Server(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new FabricPlatformInfo(PlatformInfo.Type.SERVER);
    }

    @Override
    public String getCommandName() {
        return "spark";
    }
}

