/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;

public class PlayerInventoryProvider {
    public static final String MAIN_INVENTORY = "main";
    public static final String OFFHAND_INVENTORY = "offhand";
    public static final String ARMOR_INVENTORY = "armor";
    private final Map<String, PlayerInventoryHandler> playerInventoryHandlers = new LinkedHashMap<String, PlayerInventoryHandler>();
    private final List<String> renderedHandlers = new ArrayList<String>();
    private boolean playerInventoryHandlersInitialized = false;
    private Consumer<PlayerEntity> playerInventoryHandlerInitCallback = player -> {};

    public PlayerInventoryProvider() {
        this.addPlayerInventoryHandler(MAIN_INVENTORY, player -> player.field_71071_by.field_70462_a.size(), (player, slot) -> (ItemStack)player.field_71071_by.field_70462_a.get(slot.intValue()), (player, slot, stack) -> player.field_71071_by.field_70462_a.set(slot, (Object)stack), true, false, false);
        this.addPlayerInventoryHandler(OFFHAND_INVENTORY, player -> player.field_71071_by.field_184439_c.size(), (player, slot) -> (ItemStack)player.field_71071_by.field_184439_c.get(slot.intValue()), (player, slot, stack) -> player.field_71071_by.field_184439_c.set(slot, (Object)stack), false, false, false);
        this.addPlayerInventoryHandler(ARMOR_INVENTORY, player -> 1, (player, slot) -> (ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.CHEST.func_188454_b()), (player, slot, stack) -> player.field_71071_by.field_70460_b.set(EquipmentSlotType.CHEST.func_188454_b(), (Object)stack), false, true, false);
    }

    public void setPlayerInventoryHandlerInitCallback(Consumer<PlayerEntity> callback) {
        this.playerInventoryHandlerInitCallback = callback;
        this.playerInventoryHandlersInitialized = false;
    }

    public void addPlayerInventoryHandler(String name, Function<PlayerEntity, Integer> getSlotCount, BiFunction<PlayerEntity, Integer, ItemStack> getStackInSlot, PlayerInventoryHandler.IStackInSlotModifier setStackInSlot, boolean visibleInGui, boolean rendered, boolean ownRenderer) {
        LinkedHashMap<String, PlayerInventoryHandler> temp = new LinkedHashMap<String, PlayerInventoryHandler>(this.playerInventoryHandlers);
        this.playerInventoryHandlers.clear();
        this.playerInventoryHandlers.put(name, new PlayerInventoryHandler(getSlotCount, getStackInSlot, setStackInSlot, visibleInGui, ownRenderer));
        this.playerInventoryHandlers.putAll(temp);
        if (rendered) {
            ArrayList<String> tempRendered = new ArrayList<String>(this.renderedHandlers);
            this.renderedHandlers.clear();
            this.renderedHandlers.add(name);
            this.renderedHandlers.addAll(tempRendered);
        }
    }

    public Optional<RenderInfo> getBackpackFromRendered(PlayerEntity player) {
        this.initialize(player);
        for (String handlerName : this.renderedHandlers) {
            PlayerInventoryHandler invHandler = this.playerInventoryHandlers.get(handlerName);
            for (int slot = 0; slot < invHandler.getSlotCount(player); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(player, slot);
                if (!(slotStack.func_77973_b() instanceof BackpackItem)) continue;
                return invHandler.hasItsOwnRenderer() ? Optional.empty() : Optional.of(new RenderInfo(slotStack, handlerName.equals(ARMOR_INVENTORY)));
            }
        }
        return Optional.empty();
    }

    private Map<String, PlayerInventoryHandler> getPlayerInventoryHandlers(PlayerEntity player) {
        this.initialize(player);
        return this.playerInventoryHandlers;
    }

    private void initialize(PlayerEntity player) {
        if (!this.playerInventoryHandlersInitialized) {
            this.playerInventoryHandlerInitCallback.accept(player);
            this.playerInventoryHandlersInitialized = true;
        }
    }

    public Optional<PlayerInventoryHandler> getPlayerInventoryHandler(PlayerEntity player, String name) {
        return Optional.ofNullable(this.getPlayerInventoryHandlers(player).get(name));
    }

    public void runOnBackpacks(PlayerEntity player, BackpackInventorySlotConsumer backpackInventorySlotConsumer) {
        for (Map.Entry<String, PlayerInventoryHandler> entry : this.getPlayerInventoryHandlers(player).entrySet()) {
            PlayerInventoryHandler invHandler = entry.getValue();
            for (int slot = 0; slot < invHandler.getSlotCount(player); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(player, slot);
                if (!(slotStack.func_77973_b() instanceof BackpackItem) || !backpackInventorySlotConsumer.accept(slotStack, entry.getKey(), slot)) continue;
                return;
            }
        }
    }

    public static class RenderInfo {
        private final ItemStack backpack;
        private final boolean isArmorSlot;

        public RenderInfo(ItemStack backpack, boolean isArmorSlot) {
            this.backpack = backpack;
            this.isArmorSlot = isArmorSlot;
        }

        public ItemStack getBackpack() {
            return this.backpack;
        }

        public boolean isArmorSlot() {
            return this.isArmorSlot;
        }
    }

    public static interface BackpackInventorySlotConsumer {
        public boolean accept(ItemStack var1, String var2, int var3);
    }
}

