/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.FluidFilterContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.PumpUpgradeWrapper;

public class PumpUpgradeContainer
extends UpgradeContainerBase<PumpUpgradeWrapper, PumpUpgradeContainer> {
    private static final String DATA_IS_INPUT = "isInput";
    private static final String DATA_INTERACT_WITH_HAND = "interactWithHand";
    private static final String DATA_INTERACT_WITH_WORLD = "interactWithWorld";
    private final FluidFilterContainer fluidFilterContainer;

    public PumpUpgradeContainer(PlayerEntity player, int upgradeContainerId, PumpUpgradeWrapper upgradeWrapper, UpgradeContainerType<PumpUpgradeWrapper, PumpUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.fluidFilterContainer = new FluidFilterContainer(player, this, upgradeWrapper::getFluidFilterLogic);
    }

    public void setIsInput(boolean input) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setIsInput(input);
        this.sendBooleanToServer(DATA_IS_INPUT, input);
    }

    public boolean isInput() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).isInput();
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_IS_INPUT)) {
            this.setIsInput(data.func_74767_n(DATA_IS_INPUT));
        } else if (data.func_74764_b(DATA_INTERACT_WITH_HAND)) {
            this.setInteractWithHand(data.func_74767_n(DATA_INTERACT_WITH_HAND));
        } else if (data.func_74764_b(DATA_INTERACT_WITH_WORLD)) {
            this.setInteractWithWorld(data.func_74767_n(DATA_INTERACT_WITH_WORLD));
        }
        this.fluidFilterContainer.handleMessage(data);
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilterContainer;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithHand(interactWithHand);
        this.sendBooleanToServer(DATA_INTERACT_WITH_HAND, interactWithHand);
    }

    public boolean shouldInteractWithHand() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithHand();
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithWorld(interactWithWorld);
        this.sendBooleanToServer(DATA_INTERACT_WITH_WORLD, interactWithWorld);
    }

    public boolean shouldInteractWithWorld() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithWorld();
    }
}

