/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.ServerBackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class JukeboxUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, JukeboxUpgradeItem>
    implements ITickableUpgrade {
        private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
        private final ItemStackHandler discInventory;
        private long lastKeepAliveSendTime = 0L;
        private boolean isPlaying;

        protected Wrapper(IBackpackWrapper backpackWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler);
            this.discInventory = new ItemStackHandler(1){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    upgrade.func_77983_a("discInventory", (INBT)this.serializeNBT());
                    this.save();
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return stack.func_77973_b() instanceof MusicDiscItem;
                }
            };
            NBTHelper.getCompound(upgrade, "discInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.discInventory).deserializeNBT(arg_0));
            this.isPlaying = NBTHelper.getBoolean(upgrade, "isPlaying").orElse(false);
        }

        public void setDisc(ItemStack disc) {
            this.discInventory.setStackInSlot(0, disc);
        }

        public ItemStack getDisc() {
            return this.discInventory.getStackInSlot(0);
        }

        public void play(World world, BlockPos pos) {
            this.play(world, (ServerWorld serverWorld, UUID backpackUuid) -> ServerBackpackSoundHandler.startPlayingDisc(serverWorld, pos, backpackUuid, Item.func_150891_b((Item)this.getDisc().func_77973_b()), () -> this.setIsPlaying(false)));
        }

        public void play(LivingEntity entity) {
            this.play(entity.field_70170_p, (ServerWorld world, UUID backpackUuid) -> ServerBackpackSoundHandler.startPlayingDisc(world, entity.func_213303_ch(), backpackUuid, entity.func_145782_y(), Item.func_150891_b((Item)this.getDisc().func_77973_b()), () -> this.setIsPlaying(false)));
        }

        private void play(World world, BiConsumer<ServerWorld, UUID> play) {
            if (!(world instanceof ServerWorld) || this.getDisc().func_190926_b()) {
                return;
            }
            this.backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> play.accept((ServerWorld)world, (UUID)backpackUuid));
            this.setIsPlaying(true);
        }

        private void setIsPlaying(boolean playing) {
            this.isPlaying = playing;
            NBTHelper.setBoolean(this.upgrade, "isPlaying", playing);
            if (this.isPlaying) {
                this.backpackWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
            } else {
                this.backpackWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
            }
            this.save();
        }

        public void stop(LivingEntity entity) {
            if (!(entity.field_70170_p instanceof ServerWorld)) {
                return;
            }
            this.backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> ServerBackpackSoundHandler.stopPlayingDisc((ServerWorld)entity.field_70170_p, entity.func_213303_ch(), backpackUuid));
            this.setIsPlaying(false);
        }

        public IItemHandler getDiscInventory() {
            return this.discInventory;
        }

        @Override
        public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
            if (this.isPlaying && this.lastKeepAliveSendTime < world.func_82737_E() - 5L) {
                this.backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> ServerBackpackSoundHandler.updateKeepAlive(backpackUuid, world, entity != null ? entity.func_213303_ch() : Vector3d.func_237489_a_((Vector3i)pos), () -> this.setIsPlaying(false)));
                this.lastKeepAliveSendTime = world.func_82737_E();
            }
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }
    }
}

