/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import com.google.common.collect.ImmutableMap;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogicContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicControl;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicControlBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;

public abstract class ContentsFilterControl
extends FilterLogicControl<ContentsFilterLogic, ContentsFilterLogicContainer> {
    public static final ButtonDefinition.Toggle<ContentsFilterType> BACKPACK_CONTENTS_FILTER_TYPE = ButtonDefinitions.createToggleButtonDefinition(ImmutableMap.of((Object)((Object)ContentsFilterType.ALLOW), (Object)GuiHelper.getButtonStateData(new UV(0, 0), TranslationHelper.translUpgradeButton("allow"), Dimension.SQUARE_16, new Position(1, 1)), (Object)((Object)ContentsFilterType.BLOCK), (Object)GuiHelper.getButtonStateData(new UV(16, 0), TranslationHelper.translUpgradeButton("block"), Dimension.SQUARE_16, new Position(1, 1)), (Object)((Object)ContentsFilterType.BACKPACK), (Object)GuiHelper.getButtonStateData(new UV(80, 16), TranslationHelper.translUpgradeButton("match_backpack_contents"), Dimension.SQUARE_16, new Position(1, 1))));

    protected ContentsFilterControl(BackpackScreen screen, Position position, ContentsFilterLogicContainer filterLogicContainer, int slotsPerRow, FilterLogicControlBase.MatchButton ... matchButtons) {
        super(screen, position, filterLogicContainer, slotsPerRow, true, matchButtons);
        this.addChild(new ToggleButton<ContentsFilterType>(new Position(this.x, this.y), BACKPACK_CONTENTS_FILTER_TYPE, button -> this.updateFilterType(), ((ContentsFilterLogicContainer)this.container)::getFilterType));
    }

    private void updateFilterType() {
        ContentsFilterType next = ((ContentsFilterLogicContainer)this.container).getFilterType().next();
        if (((ContentsFilterLogicContainer)this.container).getPrimaryMatch() == PrimaryMatch.TAGS && next == ContentsFilterType.BACKPACK) {
            next = next.next();
        }
        ((ContentsFilterLogicContainer)this.container).setFilterType(next);
        boolean slotsEnabled = next != ContentsFilterType.BACKPACK;
        ((ContentsFilterLogicContainer)this.container).getFilterSlots().forEach(slot -> slot.setEnabled(slotsEnabled));
    }

    @Override
    protected void onTagsMatchSelected() {
        if (((ContentsFilterLogicContainer)this.container).getFilterType() == ContentsFilterType.BACKPACK) {
            this.updateFilterType();
        }
    }

    public static class Advanced
    extends ContentsFilterControl {
        public Advanced(BackpackScreen screen, Position position, ContentsFilterLogicContainer filterLogicContainer, int slotsPerRow) {
            super(screen, position, filterLogicContainer, slotsPerRow, FilterLogicControlBase.MatchButton.PRIMARY_MATCH, FilterLogicControlBase.MatchButton.DURABILITY, FilterLogicControlBase.MatchButton.NBT);
        }
    }

    public static class Basic
    extends ContentsFilterControl {
        public Basic(BackpackScreen screen, Position position, ContentsFilterLogicContainer filterLogicContainer, int slotsPerRow) {
            super(screen, position, filterLogicContainer, slotsPerRow, new FilterLogicControlBase.MatchButton[0]);
        }
    }
}

