/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;

public class CraftingContainerRecipeTransferHandlerServer {
    private CraftingContainerRecipeTransferHandlerServer() {
    }

    public static void setItems(PlayerEntity player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        if (!(player.field_71070_bA instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer container = (BackpackContainer)player.field_71070_bA;
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.func_75139_a(entry.getValue());
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack.func_190926_b()) {
                return;
            }
            ItemStack stack = slotStack.func_77946_l();
            stack.func_190920_e(1);
            slotMap.put(entry.getKey(), stack);
        }
        Map<Integer, ItemStack> toTransfer = CraftingContainerRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        List<ItemStack> clearedCraftingItems = CraftingContainerRecipeTransferHandlerServer.clearAndPutItemsIntoGrid(player, craftingSlots, container, toTransfer);
        CraftingContainerRecipeTransferHandlerServer.putIntoInventory(player, inventorySlots, container, clearedCraftingItems);
        container.sendSlotUpdates();
        container.func_75142_b();
    }

    private static void putIntoInventory(PlayerEntity player, List<Integer> inventorySlots, BackpackContainer container, List<ItemStack> clearedCraftingItems) {
        for (ItemStack oldCraftingItem : clearedCraftingItems) {
            int added = CraftingContainerRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.func_190916_E() || player.field_71071_by.func_70441_a(oldCraftingItem)) continue;
            player.func_71019_a(oldCraftingItem, false);
        }
    }

    private static List<ItemStack> clearAndPutItemsIntoGrid(PlayerEntity player, List<Integer> craftingSlots, Container container, Map<Integer, ItemStack> toTransfer) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        int minSlotStackLimit = Integer.MAX_VALUE;
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            ItemStack transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            Slot craftingSlot = container.func_75139_a(craftingSlotNumber);
            if (!craftingSlot.func_82869_a(player)) continue;
            if (craftingSlot.func_75216_d()) {
                ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
                clearedCraftingItems.add(craftingItem);
            }
            if ((transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.func_178170_b(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        CraftingContainerRecipeTransferHandlerServer.putItemIntoGrid(craftingSlots, container, toTransfer, clearedCraftingItems, minSlotStackLimit);
        return clearedCraftingItems;
    }

    private static void putItemIntoGrid(List<Integer> craftingSlots, Container container, Map<Integer, ItemStack> toTransfer, List<ItemStack> clearedCraftingItems, int minSlotStackLimit) {
        for (Map.Entry<Integer, ItemStack> entry : toTransfer.entrySet()) {
            ItemStack stack;
            Integer craftNumber = entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            if (slot.func_75214_a(stack = entry.getValue())) {
                if (stack.func_190916_E() > minSlotStackLimit) {
                    ItemStack remainder = stack.func_77979_a(stack.func_190916_E() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.func_75215_d(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
    }

    private static Map<Integer, ItemStack> removeItemsFromInventory(PlayerEntity player, BackpackContainer container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        HashMap<Integer, ItemStack> result;
        block7: {
            boolean noItemsFound;
            result = new HashMap<Integer, ItemStack>(required.size());
            do {
                HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
                HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    ItemStack requiredStack = entry.getValue().func_77946_l();
                    Slot slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.func_75211_c().func_190926_b() && slot.func_82869_a(player);
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.func_190916_E() == resultItemStack.func_77976_d();
                    if (!itemFound || resultItemStackLimitReached) {
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            ItemStack stack = (ItemStack)slotEntry.getValue();
                            ((Slot)slotEntry.getKey()).func_75215_d(stack);
                        }
                        break block7;
                    }
                    if (!originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                    }
                    ItemStack removedItemStack = slot.func_75209_a(1);
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (ItemStack)entry.getValue());
                        continue;
                    }
                    resultItemStack.func_190917_f(1);
                }
            } while (maxTransfer && !noItemsFound);
        }
        return result;
    }

    @Nullable
    private static Slot getSlotWithStack(BackpackContainer container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(BackpackContainer container, Collection<Integer> slotIndexes, ItemStack stack) {
        Slot slot;
        ItemStack inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || (inventoryStack = (slot = container.func_75139_a(slotIndex)).func_75211_c()).func_190926_b() || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.func_190916_E() - added;
            int maxStackSize = slot.func_178170_b(inventoryStack);
            int space = maxStackSize - inventoryStack.func_190916_E();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.func_190917_f(remain);
                return stack.func_190916_E();
            }
            inventoryStack.func_190920_e(maxStackSize);
            added += space;
        }
        if (added >= stack.func_190916_E()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !(inventoryStack = (slot = container.func_75139_a(slotIndex)).func_75211_c()).func_190926_b()) continue;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(stack.func_190916_E() - added);
            slot.func_75215_d(stackToAdd);
            return stack.func_190916_E();
        }
        return added;
    }

    @Nullable
    private static Slot getSlotWithStack(BackpackContainer container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
        for (Integer slotNumber : slotNumbers) {
            Slot slot;
            ItemStack slotStack;
            if (slotNumber < 0 || slotNumber >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.func_75139_a(slotNumber)).func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)slotStack)) continue;
            return slot;
        }
        return null;
    }

    private static int getTotalSlotsSize(BackpackContainer container) {
        return container.upgradeSlots.size() + container.realInventorySlots.size();
    }
}

