/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TranslationHelper {
    private static final String TOOLTIP_SUFFIX = ".tooltip";
    private static final String GUI_PREFIX = "gui.sophisticatedbackpacks.";
    private static final String GUI_UPGRADE_PREFIX = "gui.sophisticatedbackpacks.upgrades.";
    private static final String GUI_SETTINGS_PREFIX = "gui.sophisticatedbackpacks.settings.";
    private static final String BUTTONS_SUFFIX = "buttons.";
    private static final String CONTROLS_SUFFIX = "controls.";
    private static final String BUTTONS_PREFIX = "gui.sophisticatedbackpacks.buttons.";
    private static final String ITEM_UPGRADE_PREFIX = "item.sophisticatedbackpacks.";
    private static final String UPGRADE_BUTTONS_PREFIX = "gui.sophisticatedbackpacks.upgrades.buttons.";
    private static final String UPGRADE_CONTROLS_PREFIX = "gui.sophisticatedbackpacks.upgrades.controls.";
    private static final String KEYBIND_PREFIX = "keybind.sophisticatedbackpacks.";

    private TranslationHelper() {
    }

    public static ITextComponent translUpgrade(String upgradeName) {
        return new TranslationTextComponent(TranslationHelper.translUpgradeKey(upgradeName));
    }

    public static ITextComponent translUpgradeSlotTooltip(String tooltipName) {
        return new TranslationTextComponent("gui.sophisticatedbackpacks.upgrades.slots." + tooltipName + TOOLTIP_SUFFIX);
    }

    public static String translUpgradeKey(String upgradeName) {
        return GUI_UPGRADE_PREFIX + upgradeName;
    }

    public static String translSettings(String categoryName) {
        return GUI_SETTINGS_PREFIX + categoryName;
    }

    public static String translSettingsButton(String buttonName) {
        return TranslationHelper.translSettings(BUTTONS_SUFFIX + buttonName);
    }

    public static ITextComponent translUpgradeTooltip(String upgradeName) {
        return new TranslationTextComponent(TranslationHelper.translUpgradeKey(upgradeName) + TOOLTIP_SUFFIX);
    }

    public static String translSettingsTooltip(String categoryName) {
        return TranslationHelper.translSettings(categoryName) + TOOLTIP_SUFFIX;
    }

    public static ITextComponent translColoredButton(String buttonName, TextFormatting color) {
        return new TranslationTextComponent(TranslationHelper.translButton(buttonName)).func_240699_a_(color);
    }

    public static String translButton(String buttonName) {
        return BUTTONS_PREFIX + buttonName;
    }

    public static ITextComponent translError(String key, Object ... params) {
        return new TranslationTextComponent("gui.sophisticatedbackpacks.error." + key, params);
    }

    public static String translUpgradeButton(String buttonName) {
        return UPGRADE_BUTTONS_PREFIX + buttonName;
    }

    public static String translUpgradeControl(String controlName) {
        return UPGRADE_CONTROLS_PREFIX + controlName;
    }

    public static String translItemTooltip(String itemName) {
        return ITEM_UPGRADE_PREFIX + itemName + TOOLTIP_SUFFIX;
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters, TextFormatting ... textFormattings) {
        List<StringTextComponent> ret = TranslationHelper.getTranslatedLines(translateKey, parameters);
        ret.forEach(l -> l.func_240701_a_(textFormattings));
        return ret;
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey) {
        return TranslationHelper.getTranslatedLines(translateKey, null);
    }

    public static List<StringTextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters) {
        String text = TranslationHelper.translate(translateKey, parameters);
        String[] lines = text.split("\n");
        ArrayList<StringTextComponent> ret = new ArrayList<StringTextComponent>();
        for (String line : lines) {
            ret.add(new StringTextComponent(line));
        }
        return ret;
    }

    public static String translate(String translateKey, Object ... parameters) {
        return I18n.func_135052_a((String)translateKey, (Object[])parameters);
    }

    public static String translKeybind(String keybindName) {
        return KEYBIND_PREFIX + keybindName;
    }

    public static String translGui(String guiTranslateKey) {
        return GUI_PREFIX + guiTranslateKey;
    }
}

