/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanels;

public class SolarPanelInstance
implements INBTSerializable<CompoundNBT> {
    public SolarPanel infoDelegate;
    public String delegate;
    public long gen;
    public long cap;
    public long transfer;
    public boolean valid = false;

    public SolarPanel getDelegate() {
        if (this.infoDelegate == null) {
            this.infoDelegate = SolarPanels.PANELS.get(this.delegate);
            return this.infoDelegate;
        }
        return this.infoDelegate;
    }

    public float computeSunIntensity(SolarPanelTile solar) {
        if (this.getDelegate() != null) {
            return this.infoDelegate.computeSunIntensity(solar);
        }
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.func_145831_w().func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathHelper.func_76131_a((float)(multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void reset() {
        SolarPanel info = this.getDelegate();
        boolean bl = this.valid = info != null;
        if (this.valid) {
            info.accept(this);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Delegate", this.delegate.toString());
        return nbt;
    }

    public static SolarPanelInstance deserialize(CompoundNBT nbt) {
        SolarPanelInstance inst = new SolarPanelInstance();
        inst.deserializeNBT(nbt);
        return inst;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.delegate = nbt.func_74779_i("Delegate");
        this.reset();
    }
}

