/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.block.SolarPanelBlockItem;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.items.UpgradeItem;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarPanelBlock
extends ContainerBlock
implements ICustomBlockItem {
    public final SolarPanel panel;

    public SolarPanelBlock(SolarPanel panel) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_226896_b_().harvestLevel(1).harvestTool(ToolType.PICKAXE).func_200943_b(1.5f).func_200947_a(SoundType.field_185852_e));
        this.panel = panel;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            SolarPanelTile spt = null;
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof SolarPanelTile) {
                spt = (SolarPanelTile)tile;
            } else {
                spt = (SolarPanelTile)this.func_196283_a_((IBlockReader)worldIn);
                worldIn.func_175690_a(pos, (TileEntity)spt);
            }
            spt.loadFromItem(stack);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        NonNullList stacks = NonNullList.func_191196_a();
        TileEntity tileentity = (TileEntity)builder.func_216024_a(LootParameters.field_216288_h);
        if (tileentity instanceof SolarPanelTile) {
            SolarPanelTile te = (SolarPanelTile)tileentity;
            stacks.add((Object)te.generateItem(this.panel));
        } else {
            stacks.add((Object)new ItemStack((IItemProvider)this.panel));
        }
        return stacks;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        SolarPanelTile spt;
        TileEntity tile = world.func_175625_s(pos);
        SolarPanelTile solarPanelTile = spt = tile instanceof SolarPanelTile ? (SolarPanelTile)tile : null;
        if (spt != null) {
            return spt.getShape(this);
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.networkData.height, (double)1.0);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        SolarPanelTile spt;
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        TileEntity tile = worldIn.func_175625_s(pos);
        SolarPanelTile solarPanelTile = spt = tile instanceof SolarPanelTile ? (SolarPanelTile)tile : null;
        if (spt != null) {
            spt.resetVoxelShape();
        }
    }

    public VoxelShape recalcShape(IBlockReader world, BlockPos pos) {
        VoxelShape baseShape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.networkData.height, (double)1.0);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(8);
        boolean west = false;
        boolean east = false;
        boolean north = false;
        boolean south = false;
        float h = this.panel.getPanelData().height;
        float h2 = h + 0.015625f;
        west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != this;
        if (west) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.0625, (double)0.0625, (double)h2, (double)0.9375));
        }
        if (east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.0625, (double)1.0, (double)h2, (double)0.9375));
        }
        if (north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0625, (double)h, (double)0.0, (double)0.9375, (double)h2, (double)0.0625));
        }
        if (south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0625, (double)h, (double)0.9375, (double)0.9375, (double)h2, (double)1.0));
        }
        if (west || north || world.func_180495_p(pos.func_177976_e().func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.0, (double)0.0625, (double)h2, (double)0.0625));
        }
        if (east || north || world.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.0, (double)1.0, (double)h2, (double)0.0625));
        }
        if (south || east || world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.9375, (double)1.0, (double)h2, (double)1.0));
        }
        if (west || south || world.func_180495_p(pos.func_177976_e().func_177968_d()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.9375, (double)0.0625, (double)h2, (double)1.0));
        }
        return VoxelShapes.func_216384_a((VoxelShape)baseShape, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        SolarPanelTile tbs;
        TileEntity te = worldIn.func_175625_s(pos);
        SolarPanelTile solarPanelTile = tbs = te instanceof SolarPanelTile ? (SolarPanelTile)te : null;
        if (player instanceof ServerPlayerEntity && tbs != null) {
            ItemStack held = player.func_184586_b(handIn);
            if (!held.func_190926_b() && held.func_77973_b() instanceof UpgradeItem) {
                int amt = tbs.getUpgrades(held.func_77973_b());
                UpgradeItem iu = (UpgradeItem)held.func_77973_b();
                if (amt < held.func_77976_d() && iu.canInstall(tbs, held, tbs.upgradeInventory)) {
                    boolean installed = false;
                    for (int i = 0; i < tbs.upgradeInventory.getSlots(); ++i) {
                        ItemStack stack = tbs.upgradeInventory.getStackInSlot(i);
                        if (stack.func_77969_a(held) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)held)) {
                            int allow = Math.min(held.func_77976_d() - tbs.getUpgrades(iu), Math.min(iu.getItemStackLimit(stack) - stack.func_190916_E(), held.func_190916_E()));
                            stack.func_190917_f(allow);
                            held.func_190918_g(allow);
                            installed = true;
                            break;
                        }
                        if (!stack.func_190926_b()) continue;
                        int allow = Math.min(held.func_77976_d() - tbs.getUpgrades(iu), held.func_190916_E());
                        ItemStack copy = held.func_77946_l();
                        held.func_190918_g(allow);
                        copy.func_190920_e(allow);
                        tbs.upgradeInventory.setStackInSlot(i, copy);
                        installed = true;
                        break;
                    }
                    if (installed) {
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.1f, 1.0f);
                        return ActionResultType.SUCCESS;
                    }
                }
            }
            ContainerAPI.openContainerTile((PlayerEntity)player, (TileEntity)tbs);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() == state.func_177230_c() && side != Direction.UP;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SolarPanelTile) {
            SolarPanelTile sp = (SolarPanelTile)tile;
            long cap = sp.capacity.getValueL();
            return cap > 0L ? (int)Math.round(15.0 * (double)sp.energy / (double)cap) : 0;
        }
        return 0;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        SolarPanelTile tile = new SolarPanelTile();
        tile.setDelegate(this.panel);
        return tile;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockItem createBlockItem() {
        return new SolarPanelBlockItem(this, new Item.Properties().func_200916_a(SolarFlux.ITEM_GROUP));
    }
}

