/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoadingException;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.client.adapter.ResourcePackAdapter;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.client.SolarFluxResourcePack;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.compat.ISFCompat;
import org.zeith.solarflux.compat.SFCompat;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.net.SFNetwork;
import org.zeith.solarflux.panels.SolarPanels;
import org.zeith.solarflux.proxy.SFRClientProxy;
import org.zeith.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final Logger LOG = LogManager.getLogger((String)"SolarFlux");
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)DistExecutor.unsafeRunForDist(() -> SFRClientProxy::new, () -> SFRCommonProxy::new);
    public static final ItemGroup ITEM_GROUP = new ItemGroup("solarflux"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_3);
        }
    };
    private static final List<ISFCompat> COMPATS = new ArrayList<ISFCompat>();

    public SolarFlux() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        LanguageAdapter.registerMod((String)"solarflux");
        for (Class type : ScanDataHelper.lookupAnnotatedTypes(SFCompat.class, ISFCompat.class)) {
            SFCompat sfc = type.getDeclaredAnnotation(SFCompat.class);
            if (!ModList.get().isLoaded(sfc.value())) continue;
            LOG.info("Added " + ModList.get().getModContainerById(sfc.value()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(sfc.value()) + " compatibility to Solar Flux.");
            try {
                Constructor cmp = type.getDeclaredConstructor(new Class[0]);
                cmp.setAccessible(true);
                ISFCompat compat = (ISFCompat)cmp.newInstance(new Object[0]);
                COMPATS.add(compat);
                compat.setupConfigFile(FMLPaths.CONFIGDIR.get().resolve("solarflux").resolve("compat").resolve(sfc.value() + ".hlc").toFile());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ModelLoadingException(e.getMessage(), (Throwable)e);
            }
        }
        SolarPanels.init();
        SolarFlux.processCompats(ISFCompat::registerPanels);
        ResourcePackAdapter.registerResourcePack((IResourcePack)SolarFluxResourcePack.getPackInstance());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent e) {
        PROXY.commonSetup();
        SFNetwork.init();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent e) {
        SolarPanels.refreshConfigs();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ModelBakeEvent e) {
        SolarPanels.listPanelBlocks().forEach(spb -> {
            IBakedModel cfr_ignored_0 = (IBakedModel)e.getModelRegistry().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel((SolarPanelBlock)((Object)spb)));
        });
    }

    public static void processCompats(Consumer<ISFCompat> handler) {
        COMPATS.forEach(handler);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Registration {
        @SubscribeEvent
        public static void startServer(FMLServerStartingEvent e) {
            e.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"solarflux").then(Commands.func_197057_a((String)"reload").executes(src -> {
                SolarPanels.refreshConfigs();
                ((CommandSource)src.getSource()).func_197028_i().func_184103_al().func_181057_v().forEach(SFNetwork::sendAllPanels);
                return 1;
            })));
        }
    }
}

