/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.util.color.BoxBlur;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1959;
import net.minecraft.class_3532;

public class BiomeColorCache {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final BiomeSlice biomeData;
    private final Slice[] slices;
    private final boolean[] populatedSlices;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public BiomeColorCache(BiomeSlice biomeData, int blendRadius) {
        this.biomeData = biomeData;
        this.blendRadius = blendRadius;
        int sizeXZ = 16 + (2 + this.blendRadius) * 2;
        int sizeY = 20;
        this.slices = new Slice[sizeY];
        this.populatedSlices = new boolean[sizeY];
        for (int y = 0; y < sizeY; ++y) {
            this.slices[y] = new Slice(sizeXZ);
        }
        this.tempColorBuffer = new BoxBlur.ColorBuffer(sizeXZ, sizeXZ);
    }

    public void update(ChunkRenderContext context) {
        this.minX = context.getOrigin().method_19527() - 2 - this.blendRadius;
        this.minY = context.getOrigin().method_19528() - 2;
        this.minZ = context.getOrigin().method_19529() - 2 - this.blendRadius;
        this.maxX = context.getOrigin().method_19530() + 2 + this.blendRadius;
        this.maxY = context.getOrigin().method_19531() + 2;
        this.maxZ = context.getOrigin().method_19532() + 2 + this.blendRadius;
        Arrays.fill(this.populatedSlices, false);
    }

    public int getColor(BiomeColorSource source, int blockX, int blockY, int blockZ) {
        int relX = class_3532.method_15340((int)blockX, (int)this.minX, (int)this.maxX) - this.minX;
        int relY = class_3532.method_15340((int)blockY, (int)this.minY, (int)this.maxY) - this.minY;
        int relZ = class_3532.method_15340((int)blockZ, (int)this.minZ, (int)this.maxZ) - this.minZ;
        if (!this.populatedSlices[relY]) {
            this.updateColorBuffers(relY);
        }
        Slice slice = this.slices[relY];
        BoxBlur.ColorBuffer buffer = slice.getBuffer(source);
        return buffer.get(relX, relZ);
    }

    private void updateColorBuffers(int relY) {
        Slice slice = this.slices[relY];
        int worldY = this.minY + relY;
        for (int worldZ = this.minZ; worldZ <= this.maxZ; ++worldZ) {
            for (int worldX = this.minX; worldX <= this.maxX; ++worldX) {
                class_1959 biome = this.biomeData.getBiome(worldX, worldY, worldZ);
                int relativeX = worldX - this.minX;
                int relativeZ = worldZ - this.minZ;
                slice.grass.set(relativeX, relativeZ, biome.method_8711((double)worldX, (double)worldZ));
                slice.foliage.set(relativeX, relativeZ, biome.method_8698());
                slice.water.set(relativeX, relativeZ, biome.method_8687());
            }
        }
        if (this.blendRadius > 0) {
            BoxBlur.blur(slice.grass, this.tempColorBuffer, this.blendRadius);
            BoxBlur.blur(slice.foliage, this.tempColorBuffer, this.blendRadius);
            BoxBlur.blur(slice.water, this.tempColorBuffer, this.blendRadius);
        }
        this.populatedSlices[relY] = true;
    }

    private static class Slice {
        private final BoxBlur.ColorBuffer grass;
        private final BoxBlur.ColorBuffer foliage;
        private final BoxBlur.ColorBuffer water;

        private Slice(int size) {
            this.grass = new BoxBlur.ColorBuffer(size, size);
            this.foliage = new BoxBlur.ColorBuffer(size, size);
            this.water = new BoxBlur.ColorBuffer(size, size);
        }

        public BoxBlur.ColorBuffer getBuffer(BiomeColorSource source) {
            return switch (source) {
                default -> throw new IncompatibleClassChangeError();
                case BiomeColorSource.GRASS -> this.grass;
                case BiomeColorSource.FOLIAGE -> this.foliage;
                case BiomeColorSource.WATER -> this.water;
            };
        }
    }
}

