/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Arrays;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.world.ReadableContainerExtended;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorView;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public final class WorldSlice
implements class_1920,
RenderAttachedBlockView,
BiomeColorView {
    private static final class_1944[] LIGHT_TYPES = class_1944.values();
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = class_3532.method_28139((int)2, (int)16) >> 4;
    private static final int SECTION_ARRAY_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int SECTION_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    private static final int LOCAL_XYZ_BITS = 4;
    private final class_638 world;
    private final BiomeSlice biomeSlice;
    private final BiomeColorCache biomeColors;
    private final class_2680[][] blockArrays;
    @Nullable
    private final class_2804[][] lightArrays;
    @Nullable
    private final Int2ReferenceMap<class_2586>[] blockEntityArrays;
    @Nullable
    private final Int2ReferenceMap<Object>[] blockEntityAttachmentArrays;
    private int originX;
    private int originY;
    private int originZ;

    public static ChunkRenderContext prepare(class_1937 world, class_4076 origin, ClonedChunkSectionCache sectionCache) {
        class_2818 chunk = world.method_8497(origin.method_10263(), origin.method_10260());
        class_2826 section = chunk.method_12006()[world.method_31603(origin.method_10264())];
        if (section == null || section.method_38292()) {
            return null;
        }
        class_3341 volume = new class_3341(origin.method_19527() - 2, origin.method_19528() - 2, origin.method_19529() - 2, origin.method_19530() + 2, origin.method_19531() + 2, origin.method_19532() + 2);
        int minChunkX = origin.method_10263() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.method_10264() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.method_10260() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.method_10263() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.method_10264() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.method_10260() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(class_638 world) {
        this.world = world;
        this.blockArrays = new class_2680[SECTION_ARRAY_SIZE][4096];
        this.lightArrays = new class_2804[SECTION_ARRAY_SIZE][LIGHT_TYPES.length];
        this.blockEntityArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        this.blockEntityAttachmentArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        this.biomeSlice = new BiomeSlice();
        this.biomeColors = new BiomeColorCache(this.biomeSlice, (Integer)class_310.method_1551().field_1690.method_41805().method_41753());
    }

    public void copyData(ChunkRenderContext context) {
        this.originX = context.getOrigin().method_10263() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originY = context.getOrigin().method_10264() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originZ = context.getOrigin().method_10260() - NEIGHBOR_CHUNK_RADIUS << 4;
        for (int x = 0; x < SECTION_ARRAY_LENGTH; ++x) {
            for (int y = 0; y < SECTION_ARRAY_LENGTH; ++y) {
                for (int z = 0; z < SECTION_ARRAY_LENGTH; ++z) {
                    this.copySectionData(context, WorldSlice.getLocalSectionIndex(x, y, z));
                }
            }
        }
        this.biomeSlice.update(this.world, context);
        this.biomeColors.update(context);
    }

    private void copySectionData(ChunkRenderContext context, int sectionIndex) {
        ClonedChunkSection section = context.getSections()[sectionIndex];
        Objects.requireNonNull(section, "Chunk section must be non-null");
        this.unpackBlockData(this.blockArrays[sectionIndex], context, section);
        this.lightArrays[sectionIndex][class_1944.field_9282.ordinal()] = section.getLightArray(class_1944.field_9282);
        this.lightArrays[sectionIndex][class_1944.field_9284.ordinal()] = section.getLightArray(class_1944.field_9284);
        this.blockEntityArrays[sectionIndex] = section.getBlockEntityMap();
        this.blockEntityAttachmentArrays[sectionIndex] = section.getBlockEntityAttachmentMap();
    }

    private void unpackBlockData(class_2680[] blockArray, ChunkRenderContext context, ClonedChunkSection section) {
        class_4076 pos;
        if (section.getBlockData() == null) {
            Arrays.fill(blockArray, class_2246.field_10124.method_9564());
            return;
        }
        ReadableContainerExtended<class_2680> container = ReadableContainerExtended.of(section.getBlockData());
        class_4076 origin = context.getOrigin();
        if (origin.equals((Object)(pos = section.getPosition()))) {
            container.sodium$unpack((class_2680[])blockArray);
        } else {
            class_3341 bounds = context.getVolume();
            int minBlockX = Math.max(bounds.method_35415(), pos.method_19527());
            int maxBlockX = Math.min(bounds.method_35418(), pos.method_19530());
            int minBlockY = Math.max(bounds.method_35416(), pos.method_19528());
            int maxBlockY = Math.min(bounds.method_35419(), pos.method_19531());
            int minBlockZ = Math.max(bounds.method_35417(), pos.method_19529());
            int maxBlockZ = Math.min(bounds.method_35420(), pos.method_19532());
            container.sodium$unpack((class_2680[])blockArray, minBlockX & 0xF, minBlockY & 0xF, minBlockZ & 0xF, maxBlockX & 0xF, maxBlockY & 0xF, maxBlockZ & 0xF);
        }
    }

    public void reset() {
        for (int sectionIndex = 0; sectionIndex < SECTION_ARRAY_LENGTH; ++sectionIndex) {
            Arrays.fill(this.lightArrays[sectionIndex], null);
            this.blockEntityArrays[sectionIndex] = null;
            this.blockEntityAttachmentArrays[sectionIndex] = null;
        }
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        return this.blockArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return this.world.method_24852(direction, shaded);
    }

    public class_3568 method_22336() {
        throw new UnsupportedOperationException();
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        int relZ;
        int relY;
        int relX = pos.method_10263() - this.originX;
        class_2804 lightArray = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, (relY = pos.method_10264() - this.originY) >> 4, (relZ = pos.method_10260() - this.originZ) >> 4)][type.ordinal()];
        if (lightArray == null) {
            return 0;
        }
        return lightArray.method_12139(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int method_22335(class_2338 pos, int ambientDarkness) {
        int relX = pos.method_10263() - this.originX;
        int relY = pos.method_10264() - this.originY;
        int relZ = pos.method_10260() - this.originZ;
        class_2804[] lightArrays = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        class_2804 skyLightArray = lightArrays[class_1944.field_9284.ordinal()];
        class_2804 blockLightArray = lightArrays[class_1944.field_9282.ordinal()];
        int localX = relX & 0xF;
        int localY = relY & 0xF;
        int localZ = relZ & 0xF;
        int skyLight = skyLightArray == null ? 0 : skyLightArray.method_12139(localX, localY, localZ) - ambientDarkness;
        int blockLight = blockLightArray == null ? 0 : blockLightArray.method_12139(localX, localY, localZ);
        return Math.max(blockLight, skyLight);
    }

    public class_2586 method_8321(class_2338 pos) {
        return this.getBlockEntity(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2586 getBlockEntity(int x, int y, int z) {
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        Int2ReferenceMap<class_2586> blockEntities = this.blockEntityArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        if (blockEntities == null) {
            return null;
        }
        return (class_2586)blockEntities.get(WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF));
    }

    public int method_23752(class_2338 pos, class_6539 resolver) {
        return this.biomeColors.getColor(BiomeColorSource.from(resolver), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public int method_31605() {
        return this.world.method_31605();
    }

    public int method_31607() {
        return this.world.method_31607();
    }

    @Nullable
    public Object getBlockEntityRenderAttachment(class_2338 pos) {
        int relZ;
        int relY;
        int relX = pos.method_10263() - this.originX;
        Int2ReferenceMap<Object> blockEntityAttachments = this.blockEntityAttachmentArrays[WorldSlice.getLocalSectionIndex(relX >> 4, (relY = pos.method_10264() - this.originY) >> 4, (relZ = pos.method_10260() - this.originZ) >> 4)];
        if (blockEntityAttachments == null) {
            return null;
        }
        return blockEntityAttachments.get(WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF));
    }

    @Override
    public int getColor(BiomeColorSource source, int x, int y, int z) {
        return this.biomeColors.getColor(source, x, y, z);
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 4 << 4 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH + z * SECTION_ARRAY_LENGTH + x;
    }
}

