/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.DamageSourceShip;
import com.talhanation.smallships.entities.AbstractSailBoat;
import com.talhanation.smallships.entities.TNBoatEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class AbstractShipDamage
extends AbstractSailBoat {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187193_c);

    public AbstractShipDamage(EntityType<? extends TNBoatEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab()) {
            this.setShipDamage(this.getShipDamage() + 1.5f);
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74776_a("Damage", this.getShipDamage());
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setShipDamage(nbt.func_74760_g("Damage"));
    }

    public float getShipDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setShipDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (!(source.func_76364_f() instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)source.func_76364_f();
        if (player == null) {
            return false;
        }
        if (this.func_184196_w((Entity)player)) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d && player.func_225608_bj_()) {
            this.destroyShip(source, player);
            return true;
        }
        this.destroyShip(source, player);
        return false;
    }

    public abstract ResourceLocation getLootTable();

    public void destroyShip(DamageSource source, PlayerEntity player) {
        this.onDestroyedAndDoDrops(source);
        this.func_174812_G();
    }

    public void damageShip(double damage, boolean horizontal) {
        this.setShipDamage((float)((double)this.getShipDamage() + damage));
    }

    @Override
    public boolean func_241849_j(Entity entity) {
        double speed;
        if (entity instanceof LivingEntity && !this.func_184188_bt().contains(entity) && entity.func_174813_aQ().func_72326_a(this.func_174813_aQ()) && (speed = this.func_213322_ci().func_72433_c()) > (double)0.35f) {
            float damage = Math.min((float)(speed * 10.0), 15.0f);
            entity.func_70097_a((DamageSource)DamageSourceShip.DAMAGE_SHIP, damage);
        }
        return super.func_241849_j(entity);
    }
}

