/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.Main;
import com.talhanation.smallships.entities.TNBoatEntity;
import com.talhanation.smallships.network.MessageOpenInv;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractInventoryBoat
extends TNBoatEntity {
    private LazyOptional<ItemStackHandler> itemHandler = LazyOptional.of(() -> this.inventory);
    public ItemStackHandler inventory = this.initInventory();

    public AbstractInventoryBoat(EntityType<? extends TNBoatEntity> type, World world) {
        super(type, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.breakLily();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Items"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
    }

    @Override
    public void onInvPressed(PlayerEntity player) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenInv(player));
    }

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (!byCreativePlayer) {
                this.func_199703_a((IItemProvider)this.getItemBoat());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)this.inventory.getStackInSlot(i));
        }
    }

    public void openContainer(PlayerEntity player) {
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.inventory.getSlots()) {
            this.inventory.setStackInSlot(inventorySlot, itemStackIn);
            return true;
        }
        return false;
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    private void breakLily() {
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        double offset = 0.75;
        BlockPos start = new BlockPos(boundingBox.field_72340_a - offset, boundingBox.field_72338_b - offset, boundingBox.field_72339_c - offset);
        BlockPos end = new BlockPos(boundingBox.field_72336_d + offset, boundingBox.field_72337_e + offset, boundingBox.field_72334_f + offset);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        boolean hasBroken = false;
        if (this.field_70170_p.func_175707_a(start, end)) {
            for (int i = start.func_177958_n(); i <= end.func_177958_n(); ++i) {
                for (int j = start.func_177956_o(); j <= end.func_177956_o(); ++j) {
                    for (int k = start.func_177952_p(); k <= end.func_177952_p(); ++k) {
                        pos.func_181079_c(i, j, k);
                        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)pos);
                        if (!(blockstate.func_177230_c() instanceof LilyPadBlock)) continue;
                        this.field_70170_p.func_175655_b((BlockPos)pos, true);
                        hasBroken = true;
                    }
                }
            }
        }
        if (hasBroken) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219625_by, SoundCategory.BLOCKS, 1.0f, 0.9f + 0.2f * this.field_70146_Z.nextFloat());
        }
    }

    protected abstract ItemStackHandler initInventory();

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

