/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.events;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractSailBoat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation PLANE_INFO_TEXTURE = new ResourceLocation("smallships", "textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private AbstractSailBoat lastVehicle;

    @SubscribeEvent
    public void onRender(EntityViewRenderEvent.CameraSetup evt) {
        if (this.getShip() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            evt.getInfo().func_216782_a(-evt.getInfo().func_216779_a((Double)SmallShipsConfig.ShipZoom.get() - 4.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollEvent evt) {
        if (this.getShip() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            SmallShipsConfig.ShipZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)SmallShipsConfig.ShipZoom.get() - evt.getScrollDelta())));
            SmallShipsConfig.ShipZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.equals((Object)LogicalSide.SERVER)) {
            return;
        }
        if (!evt.player.equals((Object)this.mc.field_71439_g)) {
            return;
        }
        AbstractSailBoat vehicle = this.getShip();
        if (vehicle != null && this.lastVehicle == null) {
            this.setThirdPerson(true);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!((Boolean)SmallShipsConfig.EnterThirdPerson.get()).booleanValue()) {
            return;
        }
        if (third) {
            this.mc.field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
        } else {
            this.mc.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        }
    }

    private AbstractSailBoat getShip() {
        Entity e = this.mc.field_71439_g.func_184187_bx();
        if (e instanceof AbstractSailBoat) {
            return (AbstractSailBoat)e;
        }
        return null;
    }
}

