/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications.gui.cts.script;

import com.google.common.base.Suppliers;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.Supplier;
import me.shedaniel.slightguimodifications.SlightGuiModifications;
import me.shedaniel.slightguimodifications.config.Cts;
import me.shedaniel.slightguimodifications.gui.cts.Position;
import me.shedaniel.slightguimodifications.gui.cts.elements.Text;
import me.shedaniel.slightguimodifications.gui.cts.elements.WidgetElement;
import me.shedaniel.slightguimodifications.gui.cts.widgets.CustomizedButtonWidget;
import me.shedaniel.slightguimodifications.gui.cts.widgets.LabelWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_4189;
import net.minecraft.class_426;
import net.minecraft.class_429;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4749;
import net.minecraft.class_500;
import net.minecraft.class_526;

public class Middleman {
    public static Text modMenuText() {
        return Text.literal(SlightGuiModifications.getModMenuText());
    }

    public static void url(String string) {
        class_310 client = class_310.method_1551();
        class_437 screen = client.field_1755;
        client.method_1507((class_437)new class_407(open -> {
            if (open) {
                class_156.method_668().method_670(string);
            }
            client.method_1507(screen);
        }, string, false));
    }

    public static void language() {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_426(client.field_1755, client.field_1690, client.method_1526()));
    }

    public static void options() {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_429(client.field_1755, client.field_1690));
    }

    public static void exit() {
        class_310.method_1551().method_1592();
    }

    public static void accessibility() {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_4189(client.field_1755, client.field_1690));
    }

    public static void singleplayer() {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_526(client.field_1755));
    }

    public static void multiplayer() {
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_21840) {
            client.method_1507((class_437)new class_500(client.field_1755));
        } else {
            client.method_1507((class_437)new class_4749(client.field_1755));
        }
    }

    public static void realms() {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_4325(client.field_1755));
    }

    public static void reloadCts() {
        SlightGuiModifications.resetCts();
        SlightGuiModifications.reloadCts();
        class_310.method_1551().method_1507((class_437)new class_442());
    }

    public static WidgetElement buildFromLabel(LabelBuilder builder) {
        return screen -> {
            class_1041 window = class_310.method_1551().method_22683();
            Position position = builder.getPositionBuilt();
            int alignInt = -1;
            if (builder.getAlign().equals("left")) {
                alignInt = 0;
            }
            if (builder.getAlign().equals("center")) {
                alignInt = 1;
            }
            if (builder.getAlign().equals("right")) {
                alignInt = 2;
            }
            if (alignInt == -1) {
                throw new IllegalArgumentException("Illegal alignment: $align");
            }
            return new LabelWidget(position.getX(window.method_4486()), position.getY(window.method_4502()), alignInt, builder.getText(), builder.getColor(), builder.getHoveredColor(), builder.isShadow(), builder.getOnClicked());
        };
    }

    public static WidgetElement buildFromButton(ButtonBuilder builder) {
        return screen -> {
            class_1041 window = class_310.method_1551().method_22683();
            Position position = builder.getPositionBuilt();
            double alignInt = -1.0;
            if (builder.getAlign().equals("left")) {
                alignInt = 0.0;
            }
            if (builder.getAlign().equals("center")) {
                alignInt = -0.5;
            }
            if (builder.getAlign().equals("right")) {
                alignInt = -1.0;
            }
            if (alignInt == -1.0) {
                throw new IllegalArgumentException("Illegal alignment: $align");
            }
            return new CustomizedButtonWidget((int)((double)position.getX(window.method_4486()) + (double)builder.getWidth() * alignInt), position.getY(window.method_4502()), builder.getWidth(), builder.getHeight(), builder.getText().unwrap(), button -> builder.getOnClicked().run(), (Supplier<class_2960>)Suppliers.memoize(builder.getTexture()::provide), (Supplier<class_2960>)Suppliers.memoize(builder.getHoveredTexture()::provide));
        };
    }

    public static Cts.TextureProvider file(String file) {
        return new FileTextureProvider(FabricLoader.getInstance().getGameDir().resolve(file));
    }

    public static Cts.TextureProvider resource(String file) {
        return new ResourceTextureProvider(file);
    }

    public static interface LabelBuilder {
        public String getAlign();

        public Position getPositionBuilt();

        public Text getText();

        public int getColor();

        public int getHoveredColor();

        public boolean isShadow();

        public Runnable getOnClicked();
    }

    public static interface ButtonBuilder {
        public String getAlign();

        public Position getPositionBuilt();

        public Text getText();

        public int getWidth();

        public int getHeight();

        public Runnable getOnClicked();

        public Cts.TextureProvider getTexture();

        public Cts.TextureProvider getHoveredTexture();
    }

    static class FileTextureProvider
    implements Cts.TextureProvider {
        private Path file;

        FileTextureProvider(Path file) {
            this.file = file;
        }

        @Override
        public class_2960 provide() {
            try {
                if (!Files.exists(this.file, new LinkOption[0])) {
                    throw new NoSuchFileException(this.file.toAbsolutePath().toString());
                }
                class_1060 textureManager = class_310.method_1551().method_1531();
                return textureManager.method_4617(this.file.getFileName().toString() + "_" + Files.size(this.file), new class_1043(class_1011.method_4309((InputStream)new FileInputStream(this.file.normalize().toFile()))));
            }
            catch (IOException e) {
                SlightGuiModifications.LOGGER.error("Failed to load image at " + this.file.toAbsolutePath(), (Throwable)e);
                return new class_2960("missingno");
            }
        }
    }

    static class ResourceTextureProvider
    implements Cts.TextureProvider {
        private class_2960 identifier;

        ResourceTextureProvider(String identifier) {
            this.identifier = new class_2960(identifier);
        }

        @Override
        public class_2960 provide() {
            return this.identifier;
        }
    }
}

