/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_270;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5251;
import net.minecraft.class_6025;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class HelperMethods {
    public static class_1297 getTargetedEntity(class_1297 user, int range) {
        class_238 searchBox;
        class_243 userView;
        class_243 rayCastEnd;
        class_243 rayCastOrigin = user.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)user, (class_243)rayCastOrigin, (class_243)(rayCastEnd = rayCastOrigin.method_1019(userView = user.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchBox = user.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && target instanceof class_1309, (double)(range * range));
        if (hitResult != null) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static boolean isWalking(class_1297 entity) {
        class_1657 player;
        return entity instanceof class_1657 && !(player = (class_1657)entity).method_29504() && (player.method_5681() || player.method_18798().method_37267() > 0.1);
    }

    public static class_2583 getStyle(String styleType) {
        int rgbCommon = 0xFFFFFF;
        int rgbRunic = 10314442;
        int rgbUnique = 14854196;
        int rgbLegendary = 14836276;
        int rgbAbility = 14854196;
        int rgbRightClick = 2145641;
        int rgbCorrupted = 5523848;
        int rgbCorruptedLight = 7422115;
        int rgbCorruptedAbility = 11110338;
        int rgbCorruptedText = 8288387;
        int rgbText = 0xE0E0E0;
        class_2583 COMMON = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbCommon));
        class_2583 UNIQUE = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbUnique));
        class_2583 LEGENDARY = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbLegendary));
        class_2583 ABILITY = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbAbility));
        class_2583 RIGHTCLICK = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbRightClick));
        class_2583 RUNIC = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbRunic));
        class_2583 CORRUPTED = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbCorrupted));
        class_2583 CORRUPTED_LIGHT = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbCorruptedLight));
        class_2583 CORRUPTED_ABILITY = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbCorruptedAbility));
        class_2583 CORRUPTED_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbCorruptedText));
        class_2583 TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)rgbText));
        return switch (styleType) {
            case "unique" -> UNIQUE;
            case "legendary" -> LEGENDARY;
            case "ability" -> ABILITY;
            case "rightclick" -> RIGHTCLICK;
            case "runic" -> RUNIC;
            case "corrupted" -> CORRUPTED;
            case "corrupted_light" -> CORRUPTED_LIGHT;
            case "corrupted_ability" -> CORRUPTED_ABILITY;
            case "corrupted_text" -> CORRUPTED_TEXT;
            case "text" -> TEXT;
            default -> COMMON;
        };
    }

    public static boolean checkFriendlyFire(class_1309 target, class_1309 attacker) {
        if (!HelperMethods.checkEntityBlacklist(target, attacker)) {
            return false;
        }
        class_270 playerTeam = attacker.method_5781();
        class_270 entityTeam = target.method_5781();
        if (playerTeam != null && entityTeam != null && target.method_5722((class_1297)attacker)) {
            return false;
        }
        if (target instanceof class_1657) {
            class_1657 playerAttacker;
            class_1657 playerTarget = (class_1657)target;
            if (playerTarget == attacker) {
                return false;
            }
            return !(attacker instanceof class_1657) || (playerAttacker = (class_1657)attacker).method_7256(playerTarget);
        }
        if (target instanceof class_6025) {
            class_6025 tameable = (class_6025)target;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                if (tameable.method_35057() != null) {
                    class_1309 class_13092;
                    if (tameable.method_35057() != player && (class_13092 = tameable.method_35057()) instanceof class_1657) {
                        class_1657 ownerPlayer = (class_1657)class_13092;
                        return player.method_7256(ownerPlayer);
                    }
                    return tameable.method_35057() != player;
                }
                return true;
            }
        }
        return true;
    }

    public static boolean checkEntityBlacklist(class_1309 target, class_1309 player) {
        if (target == null || player == null) {
            return false;
        }
        return !(target instanceof class_1531) && !(target instanceof class_1646) && !(target instanceof BattleStandardEntity) && !(target instanceof BattleStandardDarkEntity);
    }

    public static void spawnParticle(class_1937 world, class_2394 particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.field_9236) {
            world.method_8406(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.1);
        }
    }

    public static void playHitSounds(class_1309 attacker, class_1309 target) {
        if (!attacker.method_37908().method_8608()) {
            class_3218 world = (class_3218)attacker.method_37908();
            boolean impactsounds_enabled = Config.getBoolean("enableWeaponImpactSounds", "General", ConfigDefaultValues.enableWeaponImpactSounds);
            float impactsounds_volume = Config.getFloat("weaponImpactSoundsVolume", "General", ConfigDefaultValues.weaponImpactSoundsVolume);
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 20) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 30) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 40) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
            }
        }
    }

    public static boolean checkRunicBlacklist(String runicPower) {
        return switch (runicPower) {
            case "active_defence" -> Config.getBoolean("enableActiveDefence", "RunicEffects", ConfigDefaultValues.enableActiveDefence);
            case "float" -> Config.getBoolean("enableFloat", "RunicEffects", ConfigDefaultValues.enableFloat);
            case "greater_float" -> Config.getBoolean("enableGreaterFloat", "RunicEffects", ConfigDefaultValues.enableGreaterFloat);
            case "freeze" -> Config.getBoolean("enableFreeze", "RunicEffects", ConfigDefaultValues.enableFreeze);
            case "shielding" -> Config.getBoolean("enableShielding", "RunicEffects", ConfigDefaultValues.enableShielding);
            case "greater_shielding" -> Config.getBoolean("enableGreaterShielding", "RunicEffects", ConfigDefaultValues.enableGreaterShielding);
            case "slow" -> Config.getBoolean("enableSlow", "RunicEffects", ConfigDefaultValues.enableSlow);
            case "greater_slow" -> Config.getBoolean("enableGreaterSlow", "RunicEffects", ConfigDefaultValues.enableGreaterSlow);
            case "stoneskin" -> Config.getBoolean("enableStoneskin", "RunicEffects", ConfigDefaultValues.enableStoneskin);
            case "greater_stoneskin" -> Config.getBoolean("enableGreaterStoneskin", "RunicEffects", ConfigDefaultValues.enableGreaterStoneskin);
            case "swiftness" -> Config.getBoolean("enableSwiftness", "RunicEffects", ConfigDefaultValues.enableSwiftness);
            case "greater_swiftness" -> Config.getBoolean("enableGreaterSwiftness", "RunicEffects", ConfigDefaultValues.enableGreaterSwiftness);
            case "trailblaze" -> Config.getBoolean("enableTrailblaze", "RunicEffects", ConfigDefaultValues.enableTrailblaze);
            case "greater_trailblaze" -> Config.getBoolean("enableGreaterTrailblaze", "RunicEffects", ConfigDefaultValues.enableGreaterTrailblaze);
            case "weaken" -> Config.getBoolean("enableWeaken", "RunicEffects", ConfigDefaultValues.enableWeaken);
            case "greater_weaken" -> Config.getBoolean("enableGreaterWeaken", "RunicEffects", ConfigDefaultValues.enableGreaterWeaken);
            case "zephyr" -> Config.getBoolean("enableZephyr", "RunicEffects", ConfigDefaultValues.enableZephyr);
            case "greater_zephyr" -> Config.getBoolean("enableGreaterZephyr", "RunicEffects", ConfigDefaultValues.enableGreaterZephyr);
            case "frost_ward" -> Config.getBoolean("enableFrostWard", "RunicEffects", ConfigDefaultValues.enableFrostWard);
            case "wildfire" -> Config.getBoolean("enableWildfire", "RunicEffects", ConfigDefaultValues.enableWildfire);
            case "unstable" -> Config.getBoolean("enableUnstable", "RunicEffects", ConfigDefaultValues.enableUnstable);
            case "momentum" -> Config.getBoolean("enableMomentum", "RunicEffects", ConfigDefaultValues.enableMomentum);
            case "greater_momentum" -> Config.getBoolean("enableGreaterMomentum", "RunicEffects", ConfigDefaultValues.enableGreaterMomentum);
            case "imbued" -> Config.getBoolean("enableImbued", "RunicEffects", ConfigDefaultValues.enableImbued);
            case "greater_imbued" -> Config.getBoolean("enableGreaterImbued", "RunicEffects", ConfigDefaultValues.enableGreaterImbued);
            case "pincushion" -> Config.getBoolean("enablePincushion", "RunicEffects", ConfigDefaultValues.enablePincushion);
            case "greater_pincushion" -> Config.getBoolean("enableGreaterPincushion", "RunicEffects", ConfigDefaultValues.enableGreaterPincushion);
            case "ward" -> Config.getBoolean("enableWard", "RunicEffects", ConfigDefaultValues.enableWard);
            case "immolation" -> Config.getBoolean("enableImmolate", "RunicEffects", ConfigDefaultValues.enableImmolate);
            default -> false;
        };
    }

    public static boolean checkNetherBlacklist(String netherPower) {
        return switch (netherPower) {
            case "echo" -> Config.getBoolean("enableEcho", "GemEffects", ConfigDefaultValues.enableEcho);
            case "berserk" -> Config.getBoolean("enableBerserk", "GemEffects", ConfigDefaultValues.enableBerserk);
            case "radiance" -> Config.getBoolean("enableRadiance", "GemEffects", ConfigDefaultValues.enableRadiance);
            case "onslaught" -> Config.getBoolean("enableOnslaught", "GemEffects", ConfigDefaultValues.enableOnslaught);
            case "nullification" -> Config.getBoolean("enableNullification", "GemEffects", ConfigDefaultValues.enableNullification);
            case "precise" -> Config.getBoolean("enablePrecise", "GemEffects", ConfigDefaultValues.enablePrecise);
            case "mighty" -> Config.getBoolean("enableMighty", "GemEffects", ConfigDefaultValues.enableMighty);
            case "stealthy" -> Config.getBoolean("enableStealthy", "GemEffects", ConfigDefaultValues.enableStealthy);
            case "renewed" -> Config.getBoolean("enableRenewed", "GemEffects", ConfigDefaultValues.enableRenewed);
            case "accelerant" -> Config.getBoolean("enableAccelerant", "GemEffects", ConfigDefaultValues.enableAccelerant);
            case "leaping" -> Config.getBoolean("enableLeaping", "GemEffects", ConfigDefaultValues.enableLeaping);
            case "spellshield" -> Config.getBoolean("enableSpellshield", "GemEffects", ConfigDefaultValues.enableSpellshield);
            case "spellforged" -> Config.getBoolean("enableSpellforged", "GemEffects", ConfigDefaultValues.enableSpellforged);
            case "soulshock" -> Config.getBoolean("enableSoulshock", "GemEffects", ConfigDefaultValues.enableSoulshock);
            case "spell_standard" -> Config.getBoolean("enableSpellStandard", "GemEffects", ConfigDefaultValues.enableSpellStandard);
            case "war_standard" -> Config.getBoolean("enableWarStandard", "GemEffects", ConfigDefaultValues.enableWarStandard);
            case "deception" -> Config.getBoolean("enableDeception", "GemEffects", ConfigDefaultValues.enableDeception);
            default -> false;
        };
    }

    public static String chooseRunicPower() {
        Random choose;
        int randomIndex;
        String runicSelection;
        List<String> runicList = Arrays.asList("active_defence", "float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "frost_ward", "wildfire", "unstable", "momentum", "greater_momentum", "imbued", "greater_imbued", "pincushion", "greater_pincushion", "ward", "immolation");
        while (!HelperMethods.checkRunicBlacklist(runicSelection = runicList.get(randomIndex = (choose = new Random()).nextInt(runicList.size())))) {
        }
        return runicSelection;
    }

    public static String chooseRunefusedPower() {
        Random choose;
        int randomIndex;
        String runicSelection;
        List<String> runicList = Arrays.asList("active_defence", "float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "frost_ward", "wildfire", "unstable", "imbued", "greater_imbued", "pincushion", "greater_pincushion");
        while (!HelperMethods.checkRunicBlacklist(runicSelection = runicList.get(randomIndex = (choose = new Random()).nextInt(runicList.size())))) {
        }
        return runicSelection;
    }

    public static String chooseNetherfusedPower() {
        Random choose;
        int randomIndex;
        String netherSelection;
        List<String> netherList = Platform.isModLoaded((String)"simplyskills") ? Arrays.asList("echo", "berserk", "radiance", "onslaught", "nullification", "precise", "mighty", "stealthy", "renewed", "accelerant", "leaping", "spellshield", "spellforged", "soulshock", "spell_standard", "war_standard", "deception") : Arrays.asList("echo", "berserk", "radiance", "onslaught", "nullification");
        while (!HelperMethods.checkNetherBlacklist(netherSelection = netherList.get(randomIndex = (choose = new Random()).nextInt(netherList.size())))) {
        }
        return netherSelection;
    }

    public static boolean isUniqueTwohanded(class_1799 stack) {
        return stack.method_31574((class_1792)ItemsRegistry.SOULPYRE.get()) || stack.method_31574((class_1792)ItemsRegistry.SOULKEEPER.get()) || stack.method_31574((class_1792)ItemsRegistry.TWISTED_BLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.HEARTHFLAME.get()) || stack.method_31574((class_1792)ItemsRegistry.SOULRENDER.get()) || stack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.BRIMSTONE_CLAYMORE.get()) || stack.method_31574((class_1792)ItemsRegistry.ICEWHISPER.get()) || stack.method_31574((class_1792)ItemsRegistry.ARCANETHYST.get()) || stack.method_31574((class_1792)ItemsRegistry.THUNDERBRAND.get()) || stack.method_31574((class_1792)ItemsRegistry.WHISPERWIND.get()) || stack.method_31574((class_1792)ItemsRegistry.WATCHER_CLAYMORE.get());
    }

    public static class_238 createBox(class_1297 entity, int radius) {
        return new class_238(entity.method_23317() + (double)radius, entity.method_23318() + (double)((float)radius / 3.0f), entity.method_23321() + (double)radius, entity.method_23317() - (double)radius, entity.method_23318() - (double)((float)radius / 3.0f), entity.method_23321() - (double)radius);
    }

    public static class_243 getPositionLookingAt(class_1657 player, int range) {
        class_239 result = player.method_5745((double)range, 0.0f, false);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockResult = (class_3965)result;
        return blockResult.method_17784();
    }

    public static void incrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true));
                return;
            }
            livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        livingEntity.method_6092(new class_1293(statusEffect, duration, 0, false, false, true));
    }

    public static SimplySwordsStatusEffectInstance incrementSimplySwordsStatusEffect(class_1309 livingEntity, class_1291 statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true);
                livingEntity.method_6092((class_1293)statusReturn);
                return statusReturn;
            }
            livingEntity.method_6092(new class_1293(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, duration, 0, false, false, true);
        livingEntity.method_6092((class_1293)statusReturn);
        return statusReturn;
    }

    public static void decrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            if (currentAmplifier < 1) {
                livingEntity.method_6016(statusEffect);
                return;
            }
            livingEntity.method_6016(statusEffect);
            livingEntity.method_6092(new class_1293(statusEffect, currentDuration, currentAmplifier - 1, false, false, true));
        }
    }

    public static void createFootfalls(class_1297 entity, class_1799 stack, class_1937 world, int stepMod, class_2400 particle, class_2400 sprintParticle, class_2400 passiveParticle, boolean passiveParticles) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (Config.getBoolean("enableWeaponFootfalls", "General", ConfigDefaultValues.enableWeaponFootfalls) && player.method_6118(class_1304.field_6173) == stack) {
                if (HelperMethods.isWalking((class_1297)player) && !player.method_5681() && player.method_24828()) {
                    if (stepMod == 6) {
                        if (player.method_5624()) {
                            world.method_8406((class_2394)sprintParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406((class_2394)particle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    } else if (stepMod == 3) {
                        if (player.method_5624()) {
                            world.method_8406((class_2394)sprintParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406((class_2394)particle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (passiveParticles && Config.getBoolean("enablePassiveParticles", "General", ConfigDefaultValues.enablePassiveParticles)) {
                    float randomy = (float)Math.random();
                    if (stepMod == 1) {
                        world.method_8406((class_2394)passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216() + 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215() - 0.1, 0.0, 0.0, 0.0);
                    } else if (stepMod == 4) {
                        world.method_8406((class_2394)passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216() - 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215() + 0.1, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void spawnOrbitParticles(class_3218 world, class_243 center, class_2394 particleType, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.field_1352 + radius * Math.cos(angle);
            double z = center.field_1350 + radius * Math.sin(angle);
            double y = center.field_1351;
            world.method_14199(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnWaistHeightParticles(class_3218 world, class_2394 particle, class_1297 entity1, class_1297 entity2, int count) {
        class_243 startPos = entity1.method_19538().method_1031(0.0, (double)entity1.method_17682() / 2.0, 0.0);
        class_243 endPos = entity2.method_19538().method_1031(0.0, (double)entity2.method_17682() / 2.0, 0.0);
        class_243 direction = endPos.method_1020(startPos);
        double distance = direction.method_1033();
        class_243 normalizedDirection = direction.method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(normalizedDirection.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static float commonSpellAttributeScaling(float damageModifier, class_1297 entity, String magicSchool) {
        if (Platform.isModLoaded((String)"spell_power") && Platform.isFabric() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (Config.getBoolean("compatEnableSpellPowerScaling", "General", ConfigDefaultValues.compatEnableSpellPowerScaling)) {
                return SimplySwordsExpectPlatform.getSpellPowerDamage(damageModifier, player, magicSchool);
            }
        }
        return 0.0f;
    }
}

