/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBase;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class LampPost
extends LampBase
implements IWaterLoggable {
    public static final EnumProperty<Position> POSITION = EnumProperty.func_177709_a((String)"position", Position.class);
    private static final VoxelShape TOP_SHAPE = Stream.of(Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.func_208617_a((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)).reduce((a, b) -> VoxelShapes.func_197878_a((VoxelShape)a, (VoxelShape)b, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape MIDDLE_SHAPE = Stream.of(Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).reduce((a, b) -> VoxelShapes.func_197878_a((VoxelShape)a, (VoxelShape)b, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape BOTTOM_SHAPE = Stream.of(Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.func_208617_a((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).reduce((a, b) -> VoxelShapes.func_197878_a((VoxelShape)a, (VoxelShape)b, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public LampPost() {
        super(AbstractBlock.Properties.func_200945_a((Material)new Material(MaterialColor.field_151646_E, false, true, true, false, false, false, PushReaction.DESTROY)).harvestTool(ToolType.PICKAXE).func_235838_a_(bState -> bState.func_177229_b(POSITION) == Position.TOP ? 15 : 0).func_200943_b(2.0f).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196266_a(@Nonnull BlockState p_196266_1_, @Nonnull IBlockReader p_196266_2_, @Nonnull BlockPos p_196266_3_, @Nonnull PathType p_196266_4_) {
        return false;
    }

    @Nonnull
    public FluidState func_204507_t(BlockState pState) {
        return (Boolean)pState.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(pState);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState pState, @Nonnull IBlockReader pLevel, @Nonnull BlockPos pPos, @Nonnull ISelectionContext pContext) {
        switch ((Position)((Object)pState.func_177229_b(POSITION))) {
            case TOP: {
                return TOP_SHAPE;
            }
            case MIDDLE: {
                return MIDDLE_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{POSITION, BlockStateProperties.field_208198_y});
    }

    public void func_180633_a(World pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, @Nonnull ItemStack pStack) {
        pLevel.func_175656_a(pPos.func_177984_a(), (BlockState)pState.func_206870_a(POSITION, (Comparable)((Object)Position.MIDDLE)));
        pLevel.func_175656_a(pPos.func_177981_b(2), (BlockState)pState.func_206870_a(POSITION, (Comparable)((Object)Position.TOP)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext pContext) {
        BlockPos clickedPos = pContext.func_195995_a();
        World level = pContext.func_195991_k();
        if (clickedPos.func_177956_o() < 254 && level.func_180495_p(clickedPos.func_177984_a()).func_196953_a(pContext) && level.func_180495_p(clickedPos.func_177981_b(2)).func_196953_a(pContext)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(POSITION, (Comparable)((Object)Position.BOTTOM))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public void func_196243_a(@Nonnull BlockState pState, @Nonnull World pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pNewState, boolean pIsMoving) {
        super.func_196243_a(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pNewState.func_177230_c() == this) {
            return;
        }
        switch ((Position)((Object)pState.func_177229_b(POSITION))) {
            case TOP: {
                if (pLevel.func_180495_p(pPos.func_177977_b()).func_177230_c() instanceof LampPost) {
                    pLevel.func_175656_a(pPos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
                }
                if (!(pLevel.func_180495_p(pPos.func_177979_c(2)).func_177230_c() instanceof LampPost)) break;
                pLevel.func_175656_a(pPos.func_177979_c(2), Blocks.field_150350_a.func_176223_P());
                break;
            }
            case MIDDLE: {
                if (pLevel.func_180495_p(pPos.func_177977_b()).func_177230_c() instanceof LampPost) {
                    pLevel.func_175656_a(pPos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
                }
                if (!(pLevel.func_180495_p(pPos.func_177984_a()).func_177230_c() instanceof LampPost)) break;
                pLevel.func_175656_a(pPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                break;
            }
            case BOTTOM: {
                if (pLevel.func_180495_p(pPos.func_177984_a()).func_177230_c() instanceof LampPost) {
                    pLevel.func_175656_a(pPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                }
                if (!(pLevel.func_180495_p(pPos.func_177981_b(2)).func_177230_c() instanceof LampPost)) break;
                pLevel.func_175656_a(pPos.func_177981_b(2), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String base = this.getLangBase();
        consumer.accept(base, "Illuminant Column");
        consumer.accept(base + ".info", "3 Block tall lamp post.");
        consumer.accept(base + ".info2", "Top block emits light.");
    }

    public static enum Position implements IStringSerializable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private Position(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

