/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.SilentLib;

public final class ExclusionIngredient
extends Ingredient {
    private final Ingredient parent;
    private final Collection<Ingredient> exclusions = new ArrayList<Ingredient>();

    private ExclusionIngredient(Ingredient parent, Collection<Ingredient> exclusions) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.parent = parent;
        this.exclusions.addAll(exclusions);
    }

    public static ExclusionIngredient of(ITag<Item> tag, Ingredient ... exclusions) {
        return ExclusionIngredient.of(Ingredient.func_199805_a(tag), exclusions);
    }

    public static ExclusionIngredient of(Ingredient parent, Ingredient ... exclusions) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        Collections.addAll(list, exclusions);
        return new ExclusionIngredient(parent, list);
    }

    public static ExclusionIngredient of(ITag<Item> tag, IItemProvider ... exclusions) {
        return ExclusionIngredient.of(Ingredient.func_199805_a(tag), exclusions);
    }

    public static ExclusionIngredient of(Ingredient parent, IItemProvider ... exclusions) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (IItemProvider item : exclusions) {
            list.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }
        return new ExclusionIngredient(parent, list);
    }

    public ItemStack[] func_193365_a() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(Arrays.asList(this.parent.func_193365_a()));
        this.exclusions.forEach(ret::removeIf);
        return ret.toArray(new ItemStack[0]);
    }

    public ItemStack[] getMatchingStacksWithExclusions() {
        return this.parent.func_193365_a();
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || !this.parent.test(stack)) {
            return false;
        }
        for (Ingredient ingredient : this.exclusions) {
            if (!ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.add("value", this.parent.func_200304_c());
        JsonArray array = new JsonArray();
        this.exclusions.forEach(ingredient -> array.add(ingredient.func_200304_c()));
        json.add("exclusions", (JsonElement)array);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ExclusionIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentLib.getId("exclusion");

        @Nonnull
        public ExclusionIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.func_199802_a((JsonElement)json.get("value"));
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            for (JsonElement e : json.get("exclusions").getAsJsonArray()) {
                if (e.isJsonPrimitive()) {
                    ResourceLocation id = new ResourceLocation(e.getAsString());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (item != null) {
                        list.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
                        continue;
                    }
                    throw new JsonParseException("Unknown item: " + id);
                }
                list.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new ExclusionIngredient(value, list);
        }

        @Nonnull
        public ExclusionIngredient parse(@Nonnull PacketBuffer buffer) {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                list.add(Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new ExclusionIngredient(Ingredient.func_199566_b((PacketBuffer)buffer), list);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull ExclusionIngredient ingredient) {
            buffer.writeByte(ingredient.exclusions.size());
            for (Ingredient ing : ingredient.exclusions) {
                ing.func_199564_a(buffer);
            }
            ingredient.parent.func_199564_a(buffer);
        }
    }
}

