/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.EnchantmentTrait;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.util.NameUtils;

public final class GearData {
    private static final String NBT_ROOT = "SGear_Data";
    private static final String NBT_ROOT_CONSTRUCTION = "Construction";
    private static final String NBT_ROOT_PROPERTIES = "Properties";
    private static final String NBT_ROOT_RENDERING = "Rendering";
    private static final String NBT_ROOT_STATISTICS = "Statistics";
    private static final String NBT_CONSTRUCTION_PARTS = "Parts";
    private static final String NBT_LOCK_STATS = "LockStats";
    private static final String NBT_IS_EXAMPLE = "IsExample";
    private static final String NBT_MODEL_KEY = "ModelKey";
    private static final String NBT_SYNERGY = "synergy";
    private static final String NBT_TIER = "Tier";
    private static final String NBT_UUID = "SGear_UUID";
    private static final String NBT_BROKEN_COUNT = "BrokenCount";
    private static final String NBT_REPAIR_COUNT = "RepairCount";
    private static final String NBT_STATS = "Stats";

    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    public static void recalculateStats(ItemStack stack) {
        GearData.recalculateStats(stack, null);
    }

    public static void recalculateStats(ItemStack gear, @Nullable PlayerEntity player) {
        try {
            GearData.tryRecalculateStats(gear, player);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.func_85055_a((Throwable)ex, (String)"Failed to recalculate gear properties");
            CrashReportCategory itemCategory = report.func_85058_a("Gear Item");
            itemCategory.func_71507_a("Name", (Object)(gear.func_200301_q().getString() + " (" + NameUtils.fromItem((ItemStack)gear) + ")"));
            itemCategory.func_71507_a("Data", (Object)gear.func_196082_o().toString());
            throw new ReportedException(report);
        }
    }

    private static void tryRecalculateStats(ItemStack gear, @Nullable PlayerEntity player) {
        boolean partsListValid;
        if (GearData.checkNonGearItem(gear, "recalculateStats")) {
            return;
        }
        GearData.getUUID(gear);
        TraitHelper.activateTraits(gear, 0.0f, (trait, level, value) -> {
            trait.onRecalculatePre(new TraitActionContext(player, level, gear));
            return 0.0f;
        });
        ICoreItem item = (ICoreItem)gear.func_77973_b();
        PartDataList parts = GearData.getConstructionParts(gear);
        CompoundNBT propertiesCompound = GearData.getData(gear, NBT_ROOT_PROPERTIES);
        if (!propertiesCompound.func_74764_b(NBT_LOCK_STATS)) {
            propertiesCompound.func_74757_a(NBT_LOCK_STATS, false);
        }
        String playerName = player != null ? player.func_195047_I_() : "somebody";
        String playersItemText = String.format("%s's %s", playerName, gear.func_200301_q().getString());
        boolean statsUnlocked = !propertiesCompound.func_74767_n(NBT_LOCK_STATS);
        boolean bl = partsListValid = !parts.isEmpty() && !parts.getMains().isEmpty();
        if (statsUnlocked && partsListValid) {
            if (player != null) {
                SilentGear.LOGGER.debug("Recalculating for {}", (Object)playersItemText);
            }
            GearData.clearCachedData(gear);
            propertiesCompound.func_74778_a("ModVersion", SilentGear.getVersion());
            Map<ITrait, Integer> traits = TraitHelper.getTraits(gear, item.getGearType(), parts);
            StatModifierMap stats = GearData.getStatModifiers(gear, item, parts);
            Map<ItemStat, Float> oldStatValues = GearData.getCurrentStatsForDebugging(gear);
            int maxDamage = gear.func_77958_k() > 0 ? gear.func_77958_k() : 1;
            float damageRatio = MathHelper.func_76131_a((float)((float)gear.func_77952_i() / (float)maxDamage), (float)0.0f, (float)1.0f);
            CompoundNBT statsCompound = new CompoundNBT();
            for (ItemStat stat : stats.getStats()) {
                StatGearKey key = StatGearKey.of(stat, item.getGearType());
                Collection<StatInstance> modifiers = stats.get(key);
                GearType statGearType = stats.getMostSpecificKey(key).getGearType();
                float initialValue = stat.compute(stat.getBaseValue(), true, item.getGearType(), statGearType, modifiers);
                float withTraits = TraitHelper.activateTraits(gear, initialValue, (trait, level, val) -> {
                    TraitActionContext context = new TraitActionContext(player, level, gear);
                    return trait.onGetStat(context, stat, val, damageRatio);
                });
                float value2 = Config.Common.getStatWithMultiplier(stat, withTraits);
                ResourceLocation statId = Objects.requireNonNull(stat.getRegistryName());
                propertiesCompound.func_82580_o(statId.func_110623_a());
                statsCompound.func_74776_a(statId.toString(), stat.clampValue(value2));
            }
            propertiesCompound.func_218657_a(NBT_STATS, (INBT)statsCompound);
            if (player != null) {
                GearData.printStatsForDebugging(gear, stats, oldStatValues);
            }
            ListNBT traitList = new ListNBT();
            traits.forEach((trait, level) -> traitList.add((Object)trait.write((int)level)));
            propertiesCompound.func_218657_a("Traits", (INBT)traitList);
            propertiesCompound.func_82580_o(NBT_SYNERGY);
            if (gear.func_196082_o().func_74764_b("Enchantments") && ((Boolean)Config.Common.forceRemoveEnchantments.get()).booleanValue()) {
                SilentGear.LOGGER.debug("Forcibly removing all enchantments from {} as per config settings", (Object)playersItemText);
                gear.func_196083_e("Enchantments");
            }
            EnchantmentTrait.removeTraitEnchantments(gear);
            TraitHelper.activateTraits(gear, 0.0f, (trait, level, value) -> {
                trait.onRecalculatePost(new TraitActionContext(player, level, gear));
                return 0.0f;
            });
        } else {
            SilentGear.LOGGER.debug("Not recalculating stats for {}", (Object)playersItemText);
        }
        GearData.updateRenderingInfo(gear, parts);
    }

    @Nullable
    private static Map<ItemStat, Float> getCurrentStatsForDebugging(ItemStack stack) {
        if (((Boolean)Config.Common.statsDebugLogging.get()).booleanValue()) {
            HashMap<ItemStat, Float> map = new HashMap<ItemStat, Float>();
            ItemStats.allStatsOrdered().forEach(stat -> map.put((ItemStat)stat, Float.valueOf(GearData.getStat(stack, stat))));
            return map;
        }
        return null;
    }

    private static void printStatsForDebugging(ItemStack stack, StatModifierMap stats, @Nullable Map<ItemStat, Float> oldStats) {
        if (oldStats != null && SilentGear.LOGGER.isDebugEnabled()) {
            GearType gearType = GearHelper.getType(stack);
            Map<ItemStat, Float> newStats = GearData.getCurrentStatsForDebugging(stack);
            assert (newStats != null);
            for (ItemStat stat : stats.getStats()) {
                float oldValue = oldStats.get(stat).floatValue();
                float newValue = newStats.get(stat).floatValue();
                float change = newValue - oldValue;
                SilentGear.LOGGER.debug(" - {}: {} -> {} ({}) - mods: [{}]", (Object)stat.getDisplayName().getString(), (Object)Float.valueOf(oldValue), (Object)Float.valueOf(newValue), change < 0.0f ? Float.valueOf(change) : "+" + change, (Object)StatModifierMap.formatText(stats.get(stat, gearType), stat, 5).getString());
            }
        }
    }

    private static void clearCachedData(ItemStack stack) {
        CompoundNBT construction = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        construction.func_82580_o(NBT_TIER);
    }

    public static String getModelKey(ItemStack stack, int animationFrame) {
        String fromNbt = GearData.getData(stack, NBT_ROOT_RENDERING).func_74779_i(NBT_MODEL_KEY);
        String key = fromNbt.isEmpty() ? stack.func_196082_o().toString() : fromNbt;
        return animationFrame > 0 ? key + "_" + animationFrame : key;
    }

    private static String calculateModelKey(ItemStack stack, Collection<? extends IPartData> parts) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + ":");
        for (IPartData iPartData : parts) {
            s.append(iPartData.getModelKey()).append(',');
        }
        return s.toString();
    }

    private static void updateRenderingInfo(ItemStack stack, Collection<? extends IPartData> parts) {
        CompoundNBT nbt = GearData.getData(stack, NBT_ROOT_RENDERING);
        nbt.func_82580_o("ArmorColor");
        nbt.func_82580_o("BlendedHeadColor");
        nbt.func_74778_a(NBT_MODEL_KEY, GearData.calculateModelKey(stack, parts));
        stack.func_190925_c(NBT_ROOT).func_82580_o("ModelKeys");
    }

    public static StatModifierMap getStatModifiers(ItemStack stack, ICoreItem item, PartDataList parts) {
        GearType gearType = item.getGearType();
        StatModifierMap stats = new StatModifierMap();
        for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item.getExcludedStats(stack))) {
            StatGearKey itemKey = StatGearKey.of(stat, gearType);
            for (PartData part : parts) {
                for (StatInstance mod : part.getStatModifiers(itemKey, stack)) {
                    StatInstance modCopy = StatInstance.of(mod.getValue(), mod.getOp(), itemKey);
                    stats.put(modCopy.getKey(), modCopy);
                }
            }
        }
        return stats;
    }

    public static float getStat(ItemStack stack, IItemStat stat) {
        String key;
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74775_l(NBT_STATS);
        return tags.func_74764_b(key = stat.getStatId().toString()) ? tags.func_74760_g(key) : stat.getDefaultValue();
    }

    public static int getStatInt(ItemStack stack, IItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public static boolean hasLockedStats(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74767_n(NBT_LOCK_STATS);
    }

    public static void setLockedStats(ItemStack stack, boolean lock) {
        GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74757_a(NBT_LOCK_STATS, lock);
    }

    public static PartDataList getConstructionParts(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            return PartDataList.empty();
        }
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        PartDataList list = PartDataList.of(new PartData[0]);
        for (INBT nbt : tagList) {
            CompoundNBT partCompound;
            PartData part;
            if (!(nbt instanceof CompoundNBT) || (part = PartData.read(partCompound = (CompoundNBT)nbt)) == null) continue;
            list.add(part);
        }
        return list;
    }

    @Deprecated
    public static float getSynergyDisplayValue(ItemStack gear) {
        return 0.0f;
    }

    public static int getTier(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return -1;
        }
        CompoundNBT data = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        if (!data.func_74764_b(NBT_TIER)) {
            List<PartData> parts = GearData.getConstructionParts(gear).getMains();
            int max = 0;
            for (PartData part : parts) {
                if (part.getTier() <= max) continue;
                max = part.getTier();
            }
            data.func_74768_a(NBT_TIER, max);
        }
        return data.func_74762_e(NBT_TIER);
    }

    @Deprecated
    public static int getBlendedColor(ItemStack stack, PartType partType) {
        List<PartData> list = GearData.getConstructionParts(stack).getPartsOfType(partType);
        if (!list.isEmpty()) {
            return GearData.getBlendedColor(stack, list) & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Deprecated
    private static int getBlendedColor(ItemStack gear, List<PartData> parts) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int partCount = parts.size();
        for (int i = 0; i < partCount; ++i) {
            PartData part = parts.get(i);
            int color = part.get().getColor(part, gear, 0, 0);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (partCount - i) * (partCount - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }

    @Nullable
    public static PartData getPrimaryPart(ItemStack stack) {
        return GearData.getPartOfType(stack, PartType.MAIN);
    }

    @Nullable
    public static MaterialInstance getPrimaryMainMaterial(ItemStack stack) {
        PartData part = GearData.getPrimaryPart(stack);
        if (part != null && part.get() instanceof CompoundPart) {
            return CompoundPartItem.getPrimaryMaterial(part.getItem());
        }
        return null;
    }

    @Nullable
    public static MaterialInstance getPrimaryArmorMaterial(ItemStack stack) {
        PartData coating = GearData.getPartOfType(stack, PartType.COATING);
        if (coating != null && coating.get() instanceof CompoundPart) {
            return CompoundPartItem.getPrimaryMaterial(coating.getItem());
        }
        return GearData.getPrimaryMainMaterial(stack);
    }

    @Nullable
    public static PartData getCoatingOrMainPart(ItemStack stack) {
        PartData coating = GearData.getPartOfType(stack, PartType.COATING);
        if (coating != null) {
            return coating;
        }
        return GearData.getPartOfType(stack, PartType.MAIN);
    }

    @Nullable
    public static PartData getPartOfType(ItemStack stack, PartType type) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            PartData part = PartData.read(nbt);
            if (part == null || part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOfType(ItemStack stack, PartType type) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            String key = nbt.func_74779_i("ID");
            IGearPart part = PartManager.get(key);
            if (part == null || part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void addUpgradePart(ItemStack gear, PartData part) {
        if (!GearHelper.isGear(gear)) {
            return;
        }
        PartDataList parts = GearData.getConstructionParts(gear);
        if (!part.get().canAddToGear(gear, part)) {
            return;
        }
        if (part.get().replacesExistingInPosition(part)) {
            parts.removeIf(p -> p.getType() == part.getType());
        }
        part.onAddToGear(gear);
        for (PartData partInList : parts) {
            if (partInList.get() != part.get()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, PartType partType, Predicate<PartData> predicate) {
        for (PartData partData : GearData.getConstructionParts(gear)) {
            if (!predicate.test(partData)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, IGearPart part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    public static boolean hasPart(ItemStack gear, DataResource<IGearPart> part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    private static boolean hasPart(ItemStack gear, String partId) {
        CompoundNBT tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (INBT nbt : tagList) {
            CompoundNBT partCompound;
            String partKey;
            if (!(nbt instanceof CompoundNBT) || !(partKey = (partCompound = (CompoundNBT)nbt).func_74779_i("ID")).equals(partId)) continue;
            return true;
        }
        return false;
    }

    public static Optional<PartData> addOrReplacePart(ItemStack gear, PartData part) {
        PartType partType = part.getType();
        PartDataList parts = GearData.getConstructionParts(gear);
        List<PartData> partsOfType = parts.getPartsOfType(partType);
        PartData removedPart = null;
        if (!partsOfType.isEmpty() && partsOfType.size() >= partType.getMaxPerItem(GearHelper.getType(gear))) {
            removedPart = partsOfType.get(0);
            parts.remove(removedPart);
            removedPart.onRemoveFromGear(gear);
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        return Optional.ofNullable(removedPart);
    }

    public static void addPart(ItemStack gear, PartData part) {
        PartDataList parts = GearData.getConstructionParts(gear);
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        part.onAddToGear(gear);
    }

    public static boolean removeFirstPartOfType(ItemStack gear, PartType type) {
        PartDataList parts = GearData.getConstructionParts(gear);
        ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(type));
        if (!partsOfType.isEmpty()) {
            PartData removed = (PartData)partsOfType.remove(0);
            parts.remove(removed);
            GearData.writeConstructionParts(gear, parts);
            removed.onRemoveFromGear(gear);
            return true;
        }
        return false;
    }

    public static void removeExcessParts(ItemStack gear) {
        for (PartType type : PartType.getValues()) {
            GearData.removeExcessParts(gear, type);
        }
    }

    public static void removeExcessParts(ItemStack gear, PartType partType) {
        PartDataList parts = GearData.getConstructionParts(gear);
        ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(partType));
        int maxCount = partType.getMaxPerItem(GearHelper.getType(gear));
        int removed = 0;
        while (partsOfType.size() > maxCount) {
            PartData toRemove = (PartData)partsOfType.get(0);
            partsOfType.remove(toRemove);
            parts.remove(toRemove);
            toRemove.onRemoveFromGear(gear);
            ++removed;
            SilentGear.LOGGER.debug("Removed excess part '{}' from '{}'", (Object)toRemove.getDisplayName(gear).getString(), (Object)gear.func_200301_q().getString());
        }
        if (removed > 0) {
            GearData.writeConstructionParts(gear, parts);
        }
    }

    public static void writeConstructionParts(ItemStack gear, Collection<? extends IPartData> parts) {
        if (GearData.checkNonGearItem(gear, "writeConstructionParts")) {
            return;
        }
        CompoundNBT tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = new ListNBT();
        parts.stream().filter(p -> p.getType() == PartType.MAIN).map(p -> p.write(new CompoundNBT())).forEach(arg_0 -> tagList.add(arg_0));
        parts.stream().filter(p -> p.getType() != PartType.MAIN).map(p -> p.write(new CompoundNBT())).forEach(arg_0 -> tagList.add(arg_0));
        tags.func_218657_a(NBT_CONSTRUCTION_PARTS, (INBT)tagList);
    }

    public static UUID getUUID(ItemStack gear) {
        if (GearData.checkNonGearItem(gear, "getUUID")) {
            return new UUID(0L, 0L);
        }
        CompoundNBT tags = gear.func_196082_o();
        if (!tags.func_186855_b(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tags.func_186854_a(NBT_UUID, uuid);
            return uuid;
        }
        return tags.func_186857_a(NBT_UUID);
    }

    private static CompoundNBT getData(ItemStack gear, String compoundKey) {
        if (GearData.checkNonGearItem(gear, "getData")) {
            return new CompoundNBT();
        }
        CompoundNBT rootTag = gear.func_190925_c(NBT_ROOT);
        if (!rootTag.func_74764_b(compoundKey)) {
            rootTag.func_218657_a(compoundKey, (INBT)new CompoundNBT());
        }
        return rootTag.func_74775_l(compoundKey);
    }

    static CompoundNBT getPropertiesData(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES);
    }

    static CompoundNBT getStatisticsCompound(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_STATISTICS);
    }

    public static void setExampleTag(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_IS_EXAMPLE, value);
    }

    public static boolean isExampleGear(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_IS_EXAMPLE);
    }

    @Deprecated
    public static boolean isRandomGradingDone(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n("RandomGradingDone");
    }

    @Deprecated
    static void setRandomGradingDone(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a("RandomGradingDone", value);
    }

    public static int getBrokenCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_BROKEN_COUNT);
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_BROKEN_COUNT, GearData.getBrokenCount(stack) + 1);
    }

    public static int getRepairCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_REPAIR_COUNT);
    }

    public static void incrementRepairCount(ItemStack stack, int amount) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_REPAIR_COUNT, GearData.getRepairCount(stack) + amount);
    }

    private static boolean checkNonGearItem(ItemStack stack, String methodName) {
        if (GearHelper.isGear(stack)) {
            return false;
        }
        SilentGear.LOGGER.error("Called {} on non-gear item, {}", (Object)methodName, (Object)stack);
        SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
        return true;
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            StackList.from((IInventory)player.field_71071_by).stream().filter(s -> s.func_77973_b() instanceof ICoreItem).forEach(s -> GearData.recalculateStats(s, player));
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.getEquippedCurios((LivingEntity)player).forEach(s -> GearData.recalculateStats(s, player));
            }
        }
    }
}

