/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class SyncMaterialCraftingItemsPacket {
    private final Map<ResourceLocation, Ingredient> craftingItems = new HashMap<ResourceLocation, Ingredient>();
    private final Map<ResourceLocation, Map<PartType, Ingredient>> partSubs;

    public SyncMaterialCraftingItemsPacket() {
        this(Collections.emptyList());
    }

    public SyncMaterialCraftingItemsPacket(Collection<IMaterial> materials) {
        materials.forEach(mat -> this.craftingItems.put(mat.getId(), mat.getIngredient()));
        this.partSubs = new HashMap<ResourceLocation, Map<PartType, Ingredient>>();
        MaterialManager.getValues().forEach(mat -> PartType.getValues().forEach(type -> mat.getPartSubstitute((PartType)type).ifPresent(ing -> this.partSubs.computeIfAbsent(mat.getId(), id -> new HashMap()).put(type, ing))));
    }

    public boolean isValid() {
        return !this.craftingItems.isEmpty();
    }

    public Optional<Ingredient> getIngredient(ResourceLocation materialId) {
        return Optional.ofNullable(this.craftingItems.get(materialId));
    }

    public Map<PartType, Ingredient> getPartSubstitutes(ResourceLocation materialId) {
        return this.partSubs.getOrDefault(materialId, Collections.emptyMap());
    }

    public static SyncMaterialCraftingItemsPacket decode(PacketBuffer buffer) {
        SyncMaterialCraftingItemsPacket packet = new SyncMaterialCraftingItemsPacket();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            packet.craftingItems.put(buffer.func_192575_l(), Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int subCount = buffer.func_150792_a();
        for (int i = 0; i < subCount; ++i) {
            HashMap<PartType, Ingredient> map = new HashMap<PartType, Ingredient>();
            ResourceLocation id = buffer.func_192575_l();
            int mapCount = buffer.readByte();
            for (int j = 0; j < mapCount; ++j) {
                PartType type = PartType.get(buffer.func_192575_l());
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                map.put(type, ingredient);
            }
            packet.partSubs.put(id, map);
        }
        return packet;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.craftingItems.size());
        this.craftingItems.forEach((id, ingredient) -> {
            buffer.func_192572_a(id);
            ingredient.func_199564_a(buffer);
        });
        buffer.func_150787_b(this.partSubs.size());
        for (ResourceLocation id2 : this.partSubs.keySet()) {
            Map<PartType, Ingredient> map = this.partSubs.get(id2);
            buffer.func_192572_a(id2);
            buffer.writeByte(map.size());
            map.forEach((type, ingredient) -> {
                buffer.func_192572_a(type.getName());
                ingredient.func_199564_a(buffer);
            });
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        SilentGear.LOGGER.debug("Correcting material crafting items");
        MaterialManager.getValues().forEach(m -> m.updateIngredient(this));
        context.get().setPacketHandled(true);
    }
}

