/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartManager;

public class SyncGearCraftingItemsPacket {
    private final Map<ResourceLocation, Ingredient> craftingItems = new HashMap<ResourceLocation, Ingredient>();

    public SyncGearCraftingItemsPacket() {
        this((Map)Util.func_199748_a(() -> {
            HashMap map = new HashMap();
            PartManager.getValues().forEach(p -> map.put(p.getId(), p.getIngredient()));
            return map;
        }));
    }

    public SyncGearCraftingItemsPacket(Map<ResourceLocation, Ingredient> craftingItems) {
        this.craftingItems.putAll(craftingItems);
    }

    public static SyncGearCraftingItemsPacket fromBytes(PacketBuffer buffer) {
        SilentGear.LOGGER.debug("Gear parts crafting items packet: {} bytes", (Object)buffer.readableBytes());
        SyncGearCraftingItemsPacket packet = new SyncGearCraftingItemsPacket();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            packet.craftingItems.put(buffer.func_192575_l(), Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        return packet;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.craftingItems.size());
        this.craftingItems.forEach((id, material) -> {
            buffer.func_192572_a(id);
            material.func_199564_a(buffer);
        });
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        SilentGear.LOGGER.debug("Correcting part crafting items");
        this.craftingItems.forEach((id, ingredient) -> {
            IGearPart part = PartManager.get(id);
            if (part instanceof AbstractGearPart) {
                ((AbstractGearPart)part).updateCraftingItems((Ingredient)ingredient);
            }
        });
        context.get().setPacketHandled(true);
    }
}

