/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;

public class GearBlueprintItem
extends AbstractBlueprintItem {
    private final GearType gearType;
    private ITag.INamedTag<Item> itemTag;

    public GearBlueprintItem(GearType gearType, boolean singleUse, Item.Properties properties) {
        super(properties, singleUse);
        this.gearType = gearType;
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        return PartType.MAIN;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        return this.gearType;
    }

    @Override
    public ITag.INamedTag<Item> getItemTag() {
        ResourceLocation id;
        if (this.itemTag == null && (id = this.getRegistryName()) != null) {
            this.itemTag = ItemTags.func_199901_a((String)new ResourceLocation(id.func_110624_b(), "blueprints/" + this.gearType.getName()).toString());
        }
        return this.itemTag;
    }

    @Override
    protected ITextComponent getCraftedName(ItemStack stack) {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return new StringTextComponent("ERROR");
        }
        return new TranslationTextComponent(Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation(id.func_110624_b(), this.gearType.getName())));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String itemClass = this.gearType.getName();
        if (!this.gearType.isArmor()) {
            String key = "item." + NameUtils.fromItem((ItemStack)stack).func_110624_b() + ".blueprint." + itemClass + ".desc";
            list.add((ITextComponent)new TranslationTextComponent(key).func_240699_a_(TextFormatting.ITALIC));
        }
        if (this.isDisabled()) {
            list.add((ITextComponent)new TranslationTextComponent("item.silentgear.blueprint.disabled").func_240699_a_(TextFormatting.DARK_RED));
        } else if (this.singleUse) {
            list.add((ITextComponent)new TranslationTextComponent("item.silentgear.blueprint.singleUse").func_240699_a_(TextFormatting.RED));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("item.silentgear.blueprint.multiUse").func_240699_a_(TextFormatting.GREEN));
        }
        this.addInformationSupportedPartTypes(list);
    }

    private void addInformationSupportedPartTypes(Collection<ITextComponent> list) {
        if (KeyTracker.isDisplayStatsDown()) {
            Optional<ICoreItem> itemOptional = this.gearType.getItem();
            if (itemOptional.isPresent()) {
                TextListBuilder builder = new TextListBuilder();
                ICoreItem item = itemOptional.get();
                ItemStack gear = new ItemStack((IItemProvider)item);
                for (PartType type : PartType.getValues()) {
                    List<IGearPart> partsOfType;
                    if (type == PartType.MAIN || (partsOfType = PartManager.getPartsOfType(type)).isEmpty() || !item.supportsPart(gear, PartData.of(partsOfType.get(0)))) continue;
                    builder.add((ITextComponent)type.getDisplayName(0));
                }
                List<ITextComponent> lines = builder.build();
                if (!lines.isEmpty()) {
                    list.add((ITextComponent)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD));
                    list.addAll(lines);
                }
            }
        } else {
            list.add((ITextComponent)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), TextFormatting.GRAY)));
        }
    }
}

