/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class ModKitItem
extends Item
implements ICycleItem {
    private static final String NBT_SELECTED = "SelectedType";

    public ModKitItem(Item.Properties properties) {
        super(properties);
    }

    public static PartType getSelectedType(ItemStack stack) {
        String key = stack.func_196082_o().func_74779_i(NBT_SELECTED);
        return PartType.getNonNull(new ResourceLocation(key));
    }

    public static void setSelectedType(ItemStack stack, PartType type) {
        stack.func_196082_o().func_74778_a(NBT_SELECTED, type.getName().toString());
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, KeyPressOnItemPacket.Type direction) {
        PartType selected = ModKitItem.getSelectedType(stack);
        List<PartType> types = ModKitItem.getRemovableTypes();
        if (types.isEmpty()) {
            return;
        }
        if (selected == PartType.NONE) {
            if (direction == KeyPressOnItemPacket.Type.CYCLE_BACK) {
                ModKitItem.setSelectedType(stack, types.get(types.size() - 1));
            } else if (direction == KeyPressOnItemPacket.Type.CYCLE_NEXT) {
                ModKitItem.setSelectedType(stack, types.get(0));
            }
        } else {
            int index = types.indexOf(selected) + direction.direction;
            if (index < 0) {
                index = types.size() - 1;
            }
            if (index >= types.size()) {
                index = 0;
            }
            ModKitItem.setSelectedType(stack, types.get(index));
        }
    }

    private static List<PartType> getRemovableTypes() {
        ArrayList<PartType> list = new ArrayList<PartType>();
        for (PartType partType : PartType.getValues()) {
            if (!partType.isRemovable()) continue;
            list.add(partType);
        }
        return list;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PartType selected = ModKitItem.getSelectedType(stack);
        tooltip.add((ITextComponent)TextUtil.withColor(TextUtil.translate("item", "mod_kit.selected"), Color.SKYBLUE).func_230529_a_((ITextComponent)selected.getDisplayName(0).func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)TextUtil.translate("item", "mod_kit.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE)));
        if (flagIn.func_194127_a()) {
            StringTextComponent text = new StringTextComponent("Removable types: " + ModKitItem.getRemovableTypes().size());
            tooltip.add((ITextComponent)TextUtil.withColor((IFormattableTextComponent)text, TextFormatting.DARK_GRAY));
        }
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }
}

