/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundMaterialItem
extends Item
implements IColoredMaterialItem {
    public CompoundMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static MaterialList getSubMaterials(ItemStack stack) {
        MaterialList ret = MaterialList.empty();
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        if (!listNbt.isEmpty()) {
            for (INBT nbt : listNbt) {
                IMaterial mat = MaterialManager.get(SilentGear.getIdWithDefaultNamespace(nbt.func_150285_a_()));
                if (mat == null) continue;
                ret.add(MaterialInstance.of(mat));
            }
        } else {
            ListNBT list = stack.func_196082_o().func_150295_c("Materials", 10);
            return MaterialList.deserializeNbt(list);
        }
        return ret;
    }

    public int getCraftedCount(ItemStack stack) {
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        return listNbt.size();
    }

    public ItemStack create(MaterialList materials) {
        return this.create(materials, materials.size());
    }

    public ItemStack create(MaterialList materials, int craftedCount) {
        ItemStack result = new ItemStack((IItemProvider)this, craftedCount);
        result.func_196082_o().func_218657_a("Materials", (INBT)materials.serializeNbt());
        return result;
    }

    @Nullable
    private static IMaterialInstance getPrimaryMaterial(ItemStack stack) {
        IMaterial material;
        INBT nbt;
        ResourceLocation id;
        IMaterialInstance first = MaterialList.deserializeFirst(stack.func_196082_o().func_150295_c("Materials", 10));
        if (first != null) {
            return first;
        }
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        if (!listNbt.isEmpty() && (id = ResourceLocation.func_208304_a((String)(nbt = listNbt.get(0)).func_150285_a_())) != null && (material = MaterialManager.get(id)) != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    @Override
    @Nullable
    public IMaterialInstance getPrimarySubMaterial(ItemStack stack) {
        return CompoundMaterialItem.getPrimaryMaterial(stack);
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        if (!stack.func_77942_o()) {
            return s.append(Const.Materials.EXAMPLE.getId()).toString();
        }
        for (IMaterialInstance material : CompoundMaterialItem.getSubMaterials(stack)) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        return ColorUtils.getBlendedColor(this, (Collection<? extends IMaterialInstance>)CompoundMaterialItem.getSubMaterials(stack), layer);
    }

    public int getColorWeight(int index, int totalCount) {
        return 1;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterialInstance material = CompoundMaterialItem.getPrimaryMaterial(stack);
        ITextComponent text = material != null ? material.getDisplayName(PartType.MAIN) : TextUtil.misc("unknown", new Object[0]);
        return new TranslationTextComponent(this.func_77658_a(), new Object[]{text});
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TextUtil.addWipText(tooltip);
        MaterialList materials = CompoundMaterialItem.getSubMaterials(stack);
        TextListBuilder statsBuilder = new TextListBuilder();
        for (IMaterialInstance material : materials) {
            int nameColor = material.getNameColor(PartType.MAIN, GearType.ALL);
            statsBuilder.add((ITextComponent)TextUtil.withColor(material.getDisplayName(PartType.MAIN).func_230532_e_(), nameColor));
        }
        tooltip.addAll(statsBuilder.build());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.create(MaterialList.of(new IMaterialInstance[]{LazyMaterialInstance.of(Const.Materials.EXAMPLE)}), 1));
        }
    }
}

