/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.EnumUtils;

public class PotionEffectTrait
extends SimpleTrait {
    public static final ITraitSerializer<PotionEffectTrait> SERIALIZER = new SimpleTrait.Serializer<PotionEffectTrait>(SilentGear.getId("potion_effect_trait"), PotionEffectTrait::new, PotionEffectTrait::deserializeJson, PotionEffectTrait::readFromNetwork, PotionEffectTrait::writeToNetwork);
    private final Map<String, List<PotionData>> potions = new HashMap<String, List<PotionData>>();

    private PotionEffectTrait(ResourceLocation id) {
        this(id, (ITraitSerializer<? extends PotionEffectTrait>)SERIALIZER);
    }

    protected PotionEffectTrait(ResourceLocation id, ITraitSerializer<? extends PotionEffectTrait> serializer) {
        super(id, serializer);
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        if (!isEquipped || context.getPlayer() == null || context.getPlayer().field_70173_aa % 10 != 0) {
            return;
        }
        GearType gearType = ((ICoreItem)context.getGear().func_77973_b()).getGearType();
        for (Map.Entry<String, List<PotionData>> entry : this.potions.entrySet()) {
            String type = entry.getKey();
            List<PotionData> list = entry.getValue();
            this.applyEffects(context, gearType, type, list);
        }
    }

    private void applyEffects(TraitActionContext context, GearType gearType, String type, Iterable<PotionData> effects) {
        PlayerEntity player = context.getPlayer();
        assert (player != null);
        if (gearType.matches(type) || "all".equals(type)) {
            int setPieceCount = this.getSetPieceCount(type, player);
            boolean hasFullSet = !"armor".equals(type) || setPieceCount >= 4;
            for (PotionData potionData : effects) {
                EffectInstance effect = potionData.getEffect(context.getTraitLevel(), setPieceCount, hasFullSet);
                if (effect == null) continue;
                player.func_195064_c(effect);
            }
        }
    }

    private int getSetPieceCount(String type, PlayerEntity player) {
        if (!"armor".equals(type)) {
            return 1;
        }
        int count = 0;
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ICoreArmor) || !TraitHelper.hasTrait(stack, this)) continue;
            ++count;
        }
        return count;
    }

    static void deserializeJson(PotionEffectTrait trait, JsonObject json) {
        if (!json.has("potion_effects")) {
            throw new JsonParseException("Potion effect trait '" + trait.getId() + "' is missing 'potion_effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("potion_effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(PotionData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.potions.put(key, list);
        }
    }

    static void readFromNetwork(PotionEffectTrait trait, PacketBuffer buffer) {
        trait.potions.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            String gearType = buffer.func_218666_n();
            int potionDataCount = buffer.readByte();
            for (int potionIndex = 0; potionIndex < potionDataCount; ++potionIndex) {
                list.add(PotionData.read(buffer));
            }
            trait.potions.put(gearType, list);
        }
    }

    static void writeToNetwork(PotionEffectTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.potions.size());
        for (Map.Entry<String, List<PotionData>> entry : trait.potions.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (PotionData potionData : entry.getValue()) {
                potionData.write(buffer);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.potions.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static enum LevelType {
        TRAIT_LEVEL("by trait level"),
        PIECE_COUNT("by armor piece count"),
        FULL_SET_ONLY("requires full set of armor");

        final String wikiText;

        private LevelType(String wikiText) {
            this.wikiText = wikiText;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class PotionData {
        private LevelType type;
        private ResourceLocation effectId;
        private int duration;
        private int[] levels;

        @Deprecated
        public static PotionData of(boolean requiresFullSet, Effect effect, int ... levels) {
            return PotionData.of(requiresFullSet ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT, effect, levels);
        }

        public static PotionData of(LevelType type, Effect effect, int ... levels) {
            PotionData ret = new PotionData();
            ret.type = type;
            ret.effectId = Objects.requireNonNull(effect.getRegistryName());
            ret.duration = TimeUtils.ticksFromSeconds((float)PotionData.getDefaultDuration(ret.effectId));
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type.getName());
            json.addProperty("effect", this.effectId.toString());
            JsonArray levelsArray = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsArray).add(arg_0));
            json.add("level", (JsonElement)levelsArray);
            return json;
        }

        static PotionData from(JsonObject json) {
            PotionData ret = new PotionData();
            ret.type = PotionData.deserializeType(json);
            ret.effectId = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"effect", (String)"unknown"));
            float durationInSeconds = JSONUtils.func_151221_a((JsonObject)json, (String)"duration", (float)PotionData.getDefaultDuration(ret.effectId));
            ret.duration = TimeUtils.ticksFromSeconds((float)durationInSeconds);
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        private static LevelType deserializeType(JsonObject json) {
            if (json.has("type")) {
                return (LevelType)EnumUtils.byName((String)JSONUtils.func_151200_h((JsonObject)json, (String)"type"), (Enum)LevelType.FULL_SET_ONLY);
            }
            if (json.has("full_set")) {
                return JSONUtils.func_151212_i((JsonObject)json, (String)"full_set") ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT;
            }
            return LevelType.TRAIT_LEVEL;
        }

        static PotionData read(PacketBuffer buffer) {
            PotionData ret = new PotionData();
            ret.type = (LevelType)buffer.func_179257_a(LevelType.class);
            ret.effectId = buffer.func_192575_l();
            ret.duration = buffer.func_150792_a();
            ret.levels = buffer.func_186863_b();
            return ret;
        }

        void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)this.type);
            buffer.func_192572_a(this.effectId);
            buffer.func_150787_b(this.duration);
            buffer.func_186875_a(this.levels);
        }

        private static float getDefaultDuration(ResourceLocation effectId) {
            return new ResourceLocation("night_vision").equals((Object)effectId) ? 15.9f : 1.9f;
        }

        @Nullable
        EffectInstance getEffect(int traitLevel, int pieceCount, boolean hasFullSet) {
            if (this.type == LevelType.FULL_SET_ONLY && !hasFullSet) {
                return null;
            }
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(this.effectId);
            if (potion == null) {
                return null;
            }
            int effectLevel = this.getEffectLevel(traitLevel, pieceCount, hasFullSet);
            if (effectLevel < 1) {
                return null;
            }
            return new EffectInstance(potion, this.duration, effectLevel - 1, true, false);
        }

        int getEffectLevel(int traitLevel, int pieceCount, boolean hasFullSet) {
            switch (this.type) {
                case TRAIT_LEVEL: {
                    return this.levels[MathHelper.func_76125_a((int)(traitLevel - 1), (int)0, (int)(this.levels.length - 1))];
                }
                case PIECE_COUNT: {
                    return this.levels[MathHelper.func_76125_a((int)(pieceCount - 1), (int)0, (int)(this.levels.length - 1))];
                }
                case FULL_SET_ONLY: {
                    return this.levels[0];
                }
            }
            throw new IllegalArgumentException("Unknown level type for potion effect trait: " + (Object)((Object)this.type));
        }

        public String getWikiLine() {
            CharSequence[] levelsText = new String[this.levels.length];
            for (int i = 0; i < this.levels.length; ++i) {
                levelsText[i] = Integer.toString(this.levels[i]);
            }
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(this.effectId);
            String effectName = effect != null ? effect.func_199286_c().getString() : this.effectId.toString();
            return String.format("%s: [%s] (%s)", effectName, String.join((CharSequence)", ", levelsText), this.type.wikiText);
        }
    }
}

