/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;

public class BlockFillerTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("block_filler");
    public static final ITraitSerializer<BlockFillerTrait> SERIALIZER = new SimpleTrait.Serializer<BlockFillerTrait>(SERIALIZER_ID, BlockFillerTrait::new, BlockFillerTrait::readJson, BlockFillerTrait::read, BlockFillerTrait::write);
    @Nullable
    private Block targetBlock;
    @Nullable
    private ITag.INamedTag<Block> targetBlockTag;
    private Block fillBlock;
    private boolean replaceTileEntities;
    private int fillRangeX;
    private int fillRangeY;
    private int fillRangeZ;
    private boolean fillFacingPlaneOnly;
    private SneakMode sneakMode;
    private float damageOnUse;
    private int cooldown;
    private SoundEvent sound = SoundEvents.field_187638_cR;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public BlockFillerTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context, int traitLevel) {
        boolean hasEnoughDurability;
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_() && this.sneakMode == SneakMode.PASS) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos center = context.func_195995_a();
        int rangeX = this.shouldConstrain(context, Direction.Axis.X) ? 0 : this.fillRangeX;
        int rangeY = this.shouldConstrain(context, Direction.Axis.Y) ? 0 : this.fillRangeY;
        int rangeZ = this.shouldConstrain(context, Direction.Axis.Z) ? 0 : this.fillRangeZ;
        int replaceCount = this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, true);
        int durabilityCost = Math.round(this.damageOnUse * (float)replaceCount);
        boolean bl = hasEnoughDurability = durabilityCost < 1 || stack.func_77952_i() < stack.func_77958_k() - durabilityCost;
        if (player != null && player.field_70170_p.field_72995_K) {
            return replaceCount > 0 && hasEnoughDurability ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (hasEnoughDurability) {
            this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, false);
        }
        if (replaceCount > 0) {
            if (this.damageOnUse > 0.0f) {
                GearHelper.attemptDamage(stack, durabilityCost, (LivingEntity)player, context.func_221531_n());
            }
            if (this.sound != null) {
                float pitch = (float)((double)this.soundPitch * (1.0 + 0.05 * SilentGear.RANDOM.nextGaussian()));
                world.func_184133_a(null, center, this.sound, SoundCategory.BLOCKS, this.soundVolume, pitch);
            }
            if (this.cooldown > 0 && player != null) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.cooldown);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private int replaceBlocks(ItemUseContext context, ItemStack stack, World world, BlockPos center, int rangeX, int rangeY, int rangeZ, boolean simulate) {
        int count = 0;
        for (int x = center.func_177958_n() - rangeX; x <= center.func_177958_n() + rangeX; ++x) {
            for (int y = center.func_177956_o() - rangeY; y <= center.func_177956_o() + rangeY; ++y) {
                for (int z = center.func_177952_p() - rangeZ; z <= center.func_177952_p() + rangeZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.func_180495_p(pos);
                    if (!this.canReplace(state) || !this.replaceTileEntities && world.func_175625_s(pos) != null) continue;
                    if (!simulate) {
                        world.func_180501_a(pos, this.fillBlock.func_176223_P(), 11);
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean shouldConstrain(ItemUseContext context, Direction.Axis axis) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_() && this.sneakMode == SneakMode.CONSTRAIN) {
            return true;
        }
        return this.fillFacingPlaneOnly && context.func_196000_l().func_176740_k() == axis;
    }

    private boolean canReplace(BlockState state) {
        return this.targetBlockTag != null && state.func_235714_a_(this.targetBlockTag) || this.targetBlock != null && state.func_203425_a(this.targetBlock);
    }

    private static void readJson(BlockFillerTrait trait, JsonObject json) {
        JsonObject targetJson = JSONUtils.func_152754_s((JsonObject)json, (String)"target");
        if (targetJson.has("tag")) {
            trait.targetBlockTag = BlockTags.func_199894_a((String)JSONUtils.func_151200_h((JsonObject)targetJson, (String)"tag"));
        }
        if (targetJson.has("block")) {
            trait.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)targetJson, (String)"block")));
        }
        trait.fillBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fill_block")));
        trait.replaceTileEntities = JSONUtils.func_151209_a((JsonObject)json, (String)"replace_tile_entities", (boolean)false);
        trait.fillRangeX = JSONUtils.func_151208_a((JsonObject)json, (String)"fill_spread_x", (int)0);
        trait.fillRangeY = JSONUtils.func_151208_a((JsonObject)json, (String)"fill_spread_y", (int)0);
        trait.fillRangeZ = JSONUtils.func_151208_a((JsonObject)json, (String)"fill_spread_z", (int)0);
        trait.fillFacingPlaneOnly = JSONUtils.func_151209_a((JsonObject)json, (String)"fill_facing_plane_only", (boolean)false);
        trait.sneakMode = SneakMode.byName(JSONUtils.func_151219_a((JsonObject)json, (String)"sneak_mode", (String)"pass"));
        trait.damageOnUse = JSONUtils.func_151217_k((JsonObject)json, (String)"damage_on_use");
        trait.cooldown = JSONUtils.func_151208_a((JsonObject)json, (String)"cooldown", (int)0);
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"sound")));
        trait.soundVolume = JSONUtils.func_151217_k((JsonObject)json, (String)"sound_volume");
        trait.soundPitch = JSONUtils.func_151217_k((JsonObject)json, (String)"sound_pitch");
    }

    private static void read(BlockFillerTrait trait, PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            trait.targetBlockTag = BlockTags.func_199894_a((String)buffer.func_192575_l().toString());
        }
        if (buffer.readBoolean()) {
            trait.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        }
        trait.fillBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        trait.replaceTileEntities = buffer.readBoolean();
        trait.fillRangeX = buffer.readByte();
        trait.fillRangeY = buffer.readByte();
        trait.fillRangeZ = buffer.readByte();
        trait.fillFacingPlaneOnly = buffer.readBoolean();
        trait.sneakMode = (SneakMode)buffer.func_179257_a(SneakMode.class);
        trait.damageOnUse = buffer.readFloat();
        trait.cooldown = buffer.func_150792_a();
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.func_192575_l());
        trait.soundVolume = buffer.readFloat();
        trait.soundPitch = buffer.readFloat();
    }

    private static void write(BlockFillerTrait trait, PacketBuffer buffer) {
        buffer.writeBoolean(trait.targetBlockTag != null);
        if (trait.targetBlockTag != null) {
            buffer.func_192572_a(trait.targetBlockTag.func_230234_a_());
        }
        buffer.writeBoolean(trait.targetBlock != null);
        if (trait.targetBlock != null) {
            buffer.func_192572_a(NameUtils.from((IForgeRegistryEntry)trait.targetBlock));
        }
        buffer.func_192572_a(Objects.requireNonNull(trait.fillBlock.getRegistryName()));
        buffer.writeBoolean(trait.replaceTileEntities);
        buffer.writeByte(trait.fillRangeX);
        buffer.writeByte(trait.fillRangeY);
        buffer.writeByte(trait.fillRangeZ);
        buffer.writeBoolean(trait.fillFacingPlaneOnly);
        buffer.func_179249_a((Enum)trait.sneakMode);
        buffer.writeFloat(trait.damageOnUse);
        buffer.func_150787_b(trait.cooldown);
        buffer.func_192572_a(Objects.requireNonNull(trait.sound.getRegistryName()));
        buffer.writeFloat(trait.soundVolume);
        buffer.writeFloat(trait.soundPitch);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Fills with: " + NameUtils.from((IForgeRegistryEntry)this.fillBlock));
        ret.add("  - Replaces");
        if (this.targetBlockTag != null) {
            ret.add("    - Tag: " + this.targetBlockTag.func_230234_a_());
        }
        if (this.targetBlock != null) {
            ret.add("    - Block: " + NameUtils.from((IForgeRegistryEntry)this.targetBlock));
        }
        ret.add("    - " + (this.replaceTileEntities ? "Replaces" : "Does not replace") + " tile entities");
        int fillX = 2 * this.fillRangeX + 1;
        int fillY = 2 * this.fillRangeY + 1;
        int fillZ = 2 * this.fillRangeZ + 1;
        ret.add("  - Fill Area");
        ret.add("    - X: " + fillX + " (+" + this.fillRangeX + ")");
        ret.add("    - Y: " + fillY + " (+" + this.fillRangeY + ")");
        ret.add("    - Z: " + fillZ + " (+" + this.fillRangeZ + ")");
        if (this.fillFacingPlaneOnly) {
            ret.add("    - Fills facing plane only");
        }
        ret.add("    - On sneak: " + this.sneakMode.name());
        ret.add("  - Durability Cost: " + this.damageOnUse);
        if (this.cooldown > 0) {
            ret.add("  - Cooldown: " + this.cooldown);
        }
        return ret;
    }

    public static enum SneakMode {
        PASS,
        CONSTRAIN,
        IGNORE;


        static SneakMode byName(String name) {
            for (SneakMode value : SneakMode.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return IGNORE;
        }
    }
}

