/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class UpgradeSmithingRecipe
extends GearSmithingRecipe {
    public UpgradeSmithingRecipe(ResourceLocation recipeIdIn, ItemStack gearItem, Ingredient additionIn) {
        super(recipeIdIn, gearItem, additionIn);
    }

    @Override
    protected ItemStack applyUpgrade(ItemStack gear, ItemStack upgradeItem) {
        GearType gearType;
        PartData part = PartData.from(upgradeItem);
        if (part != null && (gearType = GearHelper.getType(gear)).isGear() && part.get().canAddToGear(gear, part) && !GearData.hasPart(gear, part.get())) {
            ItemStack result = gear.func_77946_l();
            GearData.addPart(result, part);
            GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.SMITHING_UPGRADE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UpgradeSmithingRecipe> {
        public UpgradeSmithingRecipe read(ResourceLocation recipeId, JsonObject json) {
            ItemStack gearItem = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"gear"));
            Ingredient upgradeItem = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            return new UpgradeSmithingRecipe(recipeId, gearItem, upgradeItem);
        }

        public UpgradeSmithingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack itemstack = buffer.func_150791_c();
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new UpgradeSmithingRecipe(recipeId, itemstack, ingredient1);
        }

        public void write(PacketBuffer buffer, UpgradeSmithingRecipe recipe) {
            buffer.func_150788_a(recipe.gearItem);
            recipe.field_234838_b_.func_199564_a(buffer);
        }
    }
}

