/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class ShapelessCompoundPartRecipe
extends ExtendedShapelessRecipe {
    private final CompoundPartItem item;

    public ShapelessCompoundPartRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof CompoundPartItem)) {
            throw new JsonParseException("result is not a compound part item: " + output);
        }
        this.item = (CompoundPartItem)output.func_77973_b();
    }

    protected GearType getGearType() {
        return this.item.getGearType();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.COMPOUND_PART.get();
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.getBaseRecipe().func_77569_a(inv, worldIn)) {
            return false;
        }
        IMaterial first = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat == null) continue;
            if (!mat.get().isCraftingAllowed(mat, this.item.getPartType(), this.getGearType(), (IInventory)inv)) {
                return false;
            }
            if (first == null) {
                first = mat.get();
                continue;
            }
            if (((Boolean)Config.Common.allowClassicMaterialMixing.get()).booleanValue() || first == mat.get()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        int craftedCount = this.getBaseRecipe().func_77571_b().func_190916_E();
        return this.item.create(ShapelessCompoundPartRecipe.getMaterials((IInventory)inv), craftedCount);
    }

    private static MaterialList getMaterials(IInventory inv) {
        MaterialList ret = MaterialList.empty();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            MaterialInstance material;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || (material = MaterialInstance.from(stack.func_77946_l().func_77979_a(1))) == null) continue;
            ret.add(material);
        }
        return ret;
    }

    public ItemStack func_77571_b() {
        int craftedCount = this.getBaseRecipe().func_77571_b().func_190916_E();
        return this.item.create(MaterialList.of(new IMaterialInstance[]{LazyMaterialInstance.of(Const.Materials.EXAMPLE)}), craftedCount);
    }

    public boolean func_192399_d() {
        return true;
    }
}

