/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.lib.util.NameUtils;

public class CustomCompoundIngredient
extends Ingredient {
    private final CustomMaterialItem item;
    private final ResourceLocation material;

    protected CustomCompoundIngredient(CustomMaterialItem item, ResourceLocation materialId) {
        super(Stream.of(new Ingredient.SingleItemList(item.create(LazyMaterialInstance.of(materialId)))));
        this.item = item;
        this.material = materialId;
    }

    public static CustomCompoundIngredient of(CustomMaterialItem item, IMaterial material) {
        return CustomCompoundIngredient.of(item, material.getId());
    }

    public static CustomCompoundIngredient of(CustomMaterialItem item, ResourceLocation materialId) {
        return new CustomCompoundIngredient(item, materialId);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !stack.func_77973_b().equals(this.item)) {
            return false;
        }
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        return material != null && material.getId().equals((Object)this.material);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("item", NameUtils.from((IForgeRegistryEntry)this.item).toString());
        json.addProperty("material", this.material.toString());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<CustomCompoundIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("custom_compound");

        public CustomCompoundIngredient parse(JsonObject json) {
            ResourceLocation itemId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            if (!(item instanceof CustomMaterialItem)) {
                throw new JsonParseException("Item '" + itemId + "' is not a CustomMaterialItem");
            }
            ResourceLocation materialId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"material"));
            return new CustomCompoundIngredient((CustomMaterialItem)item, materialId);
        }

        public CustomCompoundIngredient parse(PacketBuffer buffer) {
            ResourceLocation itemId = buffer.func_192575_l();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            if (!(item instanceof CustomMaterialItem)) {
                throw new JsonParseException("Item '" + itemId + "' is not a CustomMaterialItem");
            }
            ResourceLocation materialId = buffer.func_192575_l();
            return new CustomCompoundIngredient((CustomMaterialItem)item, materialId);
        }

        public void write(PacketBuffer buffer, CustomCompoundIngredient ingredient) {
            buffer.func_192572_a(NameUtils.from((IForgeRegistryEntry)ingredient.item));
            buffer.func_192572_a(ingredient.material);
        }
    }
}

