/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.Size2i;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.util.ModResourceLocation;

public class GearCraftingRecipeCategoryJei
implements IRecipeCategory<ICraftingRecipe> {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 132;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public GearCraftingRecipeCategoryJei(IGuiHelper guiHelper) {
        ModResourceLocation location = SilentGear.getId("textures/gui/gear_crafting_jei.png");
        this.background = guiHelper.createDrawable((ResourceLocation)location, 0, 0, 160, 132);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModItems.BLUEPRINT_PACKAGE));
        this.localizedName = I18n.func_135052_a((String)"gui.silentgear.category.gearCrafting", (Object[])new Object[0]);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    public ResourceLocation getUid() {
        return SGearJeiPlugin.GEAR_CRAFTING;
    }

    public Class<? extends ICraftingRecipe> getRecipeClass() {
        return ICraftingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ICraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ArrayList<List<ItemStack>> shiftedInputs = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < inputs.size(); ++i) {
            shiftedInputs.add(GearCraftingRecipeCategoryJei.shiftIngredients((List)inputs.get(i), 5 * i));
        }
        Size2i size = GearCraftingRecipeCategoryJei.getRecipeSize(recipe);
        if (size != null && size.width > 0 && size.height > 0) {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, shiftedInputs, size.width, size.height);
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, shiftedInputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    private static List<ItemStack> shiftIngredients(List<ItemStack> list, int amount) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(list);
        if (ret.isEmpty()) {
            return ret;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = (ItemStack)ret.get(ret.size() - 1);
            ret.remove(ret.size() - 1);
            ret.add(0, stack);
        }
        return ret;
    }

    public void setIngredients(ICraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ingredients.setInputIngredients((List)recipe.func_192400_c());
    }

    @Nullable
    private static Size2i getRecipeSize(ICraftingRecipe recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return new Size2i(shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight());
        }
        return null;
    }

    public void draw(ICraftingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        ArrayList<IFormattableTextComponent> lines = new ArrayList<IFormattableTextComponent>();
        NonNullList ingredients = recipe.func_192400_c();
        for (int i = 0; i < ingredients.size(); ++i) {
            ITextComponent text;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (!(ingredient instanceof IGearIngredient) || (text = (ITextComponent)((IGearIngredient)ingredient).getJeiHint().orElse(null)) == null) continue;
            String prefix = i + 1 + ": ";
            lines.add(new StringTextComponent(prefix).func_230529_a_(text));
        }
        matrixStack.func_227860_a_();
        float scale = lines.size() > 5 ? 0.75f : 1.0f;
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int y = (int)(56.0f / scale);
        for (ITextComponent iTextComponent : lines) {
            font.func_238407_a_(matrixStack, iTextComponent.func_241878_f(), 0.0f, (float)y, -1);
            y += 10;
        }
        matrixStack.func_227865_b_();
    }
}

