/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.GearData;

public final class PartsCommand {
    private static final SuggestionProvider<CommandSource> partIdSuggestions = (ctx, builder) -> ISuggestionProvider.func_212476_a(PartManager.getValues().stream().map(IGearPart::getId), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> partInGearSuggestions = (ctx, builder) -> {
        PartDataList parts = GearData.getConstructionParts(PartsCommand.getGear((CommandContext<CommandSource>)ctx));
        return ISuggestionProvider.func_212476_a(parts.getUniqueParts(false).stream().map(part -> part.get().getId()), (SuggestionsBuilder)builder);
    };
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private PartsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"sgear_parts");
        builder.then(Commands.func_197057_a((String)"list").executes(PartsCommand::runList));
        builder.then(Commands.func_197057_a((String)"dump").executes(PartsCommand::runDump));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = PartManager.getValues().stream().map(part -> part.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        for (PartType type : PartType.getValues()) {
            int count = PartManager.getPartsOfType(type).size();
            String str = String.format("%s: %d", type.getName(), count);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(str), true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDump(CommandContext<CommandSource> context) {
        String dirPath = "output/silentgear";
        String fileName = "part_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Name\tID\tType\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().getString()).append("\t"));
            builder.append("Traits");
            writer.write(builder.toString());
            for (IGearPart part : PartManager.getValues()) {
                writer.write(PartsCommand.partToTsvLine(part) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Wrote to " + output.getAbsolutePath()), true);
        }
        return 1;
    }

    private static String partToTsvLine(IGearPart part) {
        StringBuilder builder = new StringBuilder();
        PartData partData = PartData.of(part);
        PartsCommand.appendTsv(builder, part.getDisplayName(partData, ItemStack.field_190927_a).getString());
        PartsCommand.appendTsv(builder, part.getId().toString());
        PartsCommand.appendTsv(builder, part.getType().getName());
        PartsCommand.appendTsv(builder, partData.getTier());
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = partData.getStatModifiers(StatGearKey.of(stat, GearType.ALL), ItemStack.field_190927_a);
            PartsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        PartsCommand.appendTsv(builder, partData.getTraits().stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).getString()).collect(Collectors.joining(", ")));
        return builder.toString();
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ItemStack getGear(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (((CommandSource)ctx.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
            ItemStack gear = ((CommandSource)ctx.getSource()).func_197035_h().func_184614_ca();
            if (gear.func_77973_b() instanceof ICoreItem) {
                return gear;
            }
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a(PartsCommand.text("sourceMustBePlayer", new Object[0]));
        }
        return ItemStack.field_190927_a;
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TranslationTextComponent("command.silentgear.parts." + key, args);
    }
}

