/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class MetalPressTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    @SyncVariable(name="Progress")
    private int progress = 0;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return MetalPressTileEntity.this.progress;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    MetalPressTileEntity.this.progress = value;
                }
            }
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public MetalPressTileEntity() {
        super((TileEntityType)ModTileEntities.METAL_PRESS.get(), 2);
    }

    @Nullable
    public PressingRecipe getRecipe() {
        if (this.field_145850_b == null || this.func_70301_a(0).func_190926_b()) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.PRESSING_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    private ItemStack getWorkOutput(@Nullable PressingRecipe recipe) {
        if (recipe != null) {
            return recipe.func_77572_b((IInventory)this);
        }
        return ItemStack.field_190927_a;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        PressingRecipe recipe = this.getRecipe();
        if (recipe != null) {
            this.doWork(recipe);
        } else {
            this.stopWork();
        }
    }

    private void doWork(PressingRecipe recipe) {
        assert (this.field_145850_b != null);
        ItemStack current = this.func_70301_a(1);
        ItemStack output = this.getWorkOutput(recipe);
        if (!current.func_190926_b()) {
            int newCount = current.func_190916_E() + output.func_190916_E();
            if (!InventoryUtils.canItemsStack((ItemStack)current, (ItemStack)output) || newCount > output.func_77976_d()) {
                this.stopWork();
                return;
            }
        }
        if (this.progress < WORK_TIME) {
            ++this.progress;
        }
        if (this.progress >= WORK_TIME && !this.field_145850_b.field_72995_K) {
            this.finishWork(recipe, current);
        }
        this.sendUpdate((BlockState)this.func_195044_w().func_206870_a((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void stopWork() {
        this.progress = 0;
        this.sendUpdate((BlockState)this.func_195044_w().func_206870_a((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(false)));
    }

    private void finishWork(PressingRecipe recipe, ItemStack current) {
        ItemStack output = this.getWorkOutput(recipe);
        if (!current.func_190926_b()) {
            current.func_190917_f(output.func_190916_E());
        } else {
            this.func_70299_a(1, output);
        }
        this.progress = 0;
        this.func_70298_a(0, 1);
    }

    private void sendUpdate(BlockState newState) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (oldState != newState) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, oldState, newState, 3);
        }
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "metal_press");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MetalPressContainer(id, player, (IInventory)this, this.fields);
    }

    void encodeExtraData(PacketBuffer buffer) {
        buffer.writeByte(this.fields.func_221478_a());
    }
}

