/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.compounder;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.block.compounder.CompounderBlock;
import net.silentchaos512.gear.block.compounder.CompounderContainer;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.item.CompoundMaterialItem;

public class CompounderInfo<R extends CompoundingRecipe> {
    private final Supplier<CompounderBlock> block;
    private final Supplier<TileEntityType<? extends CompounderTileEntity>> tileEntityType;
    private final Supplier<ContainerType<? extends CompounderContainer>> containerType;
    private final Supplier<IRecipeType<R>> recipeType;
    private final Supplier<CompoundMaterialItem> outputItem;
    private final Supplier<IRecipeSerializer<?>> recipeSerializer;
    private final Class<R> recipeClass;
    private final int inputSlotCount;
    private final ImmutableList<IMaterialCategory> categories;

    public CompounderInfo(Collection<IMaterialCategory> categories, int inputSlotCount, Supplier<CompoundMaterialItem> outputItem, Supplier<CompounderBlock> block, Supplier<TileEntityType<? extends CompounderTileEntity>> tileEntityType, Supplier<ContainerType<? extends CompounderContainer>> containerType, Supplier<IRecipeSerializer<?>> recipeSerializer, Supplier<IRecipeType<R>> recipeType, Class<R> recipeClass) {
        this.block = block;
        this.tileEntityType = tileEntityType;
        this.containerType = containerType;
        this.recipeType = recipeType;
        this.outputItem = outputItem;
        this.recipeSerializer = recipeSerializer;
        this.inputSlotCount = inputSlotCount;
        this.categories = ImmutableList.copyOf(categories);
        this.recipeClass = recipeClass;
    }

    public CompounderBlock getBlock() {
        return this.block.get();
    }

    public TileEntityType<? extends CompounderTileEntity> getTileEntityType() {
        return this.tileEntityType.get();
    }

    public ContainerType<? extends CompounderContainer> getContainerType() {
        return this.containerType.get();
    }

    public IRecipeType<R> getRecipeType() {
        return this.recipeType.get();
    }

    public CompoundMaterialItem getOutputItem() {
        return this.outputItem.get();
    }

    public int getInputSlotCount() {
        return this.inputSlotCount;
    }

    public Collection<IMaterialCategory> getCategories() {
        return this.categories;
    }

    public Class<R> getRecipeClass() {
        return this.recipeClass;
    }

    public IRecipeSerializer<?> getRecipeSerializer() {
        return this.recipeSerializer.get();
    }
}

