/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.GearApi;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.INamedContainerExtraData;
import net.silentchaos512.gear.block.charger.ChargerContainer;
import net.silentchaos512.gear.init.GearEnchantments;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class ChargerTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity,
INamedContainerExtraData {
    static final int INVENTORY_SIZE = 3;
    private static final int CHARGE_RATE = 30 * (SilentGear.isDevBuild() ? 10 : 1);
    private static final int UPDATE_FREQUENCY = TimeUtils.ticksFromSeconds((float)15.0f);
    private final Supplier<Enchantment> enchantment;
    @SyncVariable(name="Progress")
    private int progress = 0;
    @SyncVariable(name="WorkTime")
    private int workTime = 100;
    @SyncVariable(name="Charge")
    private int charge = 0;
    @SyncVariable(name="StructureLevel")
    private int structureLevel;
    private int updateTimer = 0;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ChargerTileEntity.this.progress;
                }
                case 1: {
                    return ChargerTileEntity.this.workTime;
                }
                case 2: {
                    return ChargerTileEntity.this.structureLevel;
                }
                case 3: {
                    return ChargerTileEntity.this.charge & 0xFFFF;
                }
                case 4: {
                    return ChargerTileEntity.this.charge >> 16 & 0xFFFF;
                }
                case 5: {
                    return ChargerTileEntity.this.getMaxCharge() & 0xFFFF;
                }
                case 6: {
                    return ChargerTileEntity.this.getMaxCharge() >> 16 & 0xFFFF;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    ChargerTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ChargerTileEntity.this.workTime = value;
                    break;
                }
                case 2: {
                    ChargerTileEntity.this.structureLevel = value;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };

    public ChargerTileEntity(TileEntityType<?> tileEntityTypeIn, Supplier<Enchantment> enchantment) {
        super(tileEntityTypeIn, 3);
        this.enchantment = enchantment;
    }

    public static ChargerTileEntity createStarlightCharger() {
        return new ChargerTileEntity((TileEntityType<?>)((TileEntityType)ModTileEntities.STARLIGHT_CHARGER.get()), (Supplier<Enchantment>)GearEnchantments.STAR_CHARGED);
    }

    protected int getMaxCharge() {
        return 1000000;
    }

    @Override
    public void encodeExtraData(PacketBuffer buffer) {
        buffer.writeByte(this.fields.func_221478_a());
    }

    protected int getWorkTime(ItemStack input) {
        IMaterialInstance material = GearApi.getMaterial(input);
        if (material != null) {
            return 100 * material.getTier();
        }
        return -1;
    }

    protected int getDrainRate(ItemStack input, int level) {
        return 150 + 50 * level * level;
    }

    protected int getChargingAgentTier(ItemStack catalyst) {
        return ChargerTileEntity.getStarlightChargerCatalystTier(catalyst);
    }

    public static int getStarlightChargerCatalystTier(ItemStack catalyst) {
        for (int i = ModTags.Items.STARLIGHT_CHARGER_TIERS.size() - 1; i >= 0; --i) {
            if (!catalyst.func_77973_b().func_206844_a((ITag)ModTags.Items.STARLIGHT_CHARGER_TIERS.get(i))) continue;
            return i + 1;
        }
        return 0;
    }

    protected int getMaterialChargeLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)this.enchantment.get(), (ItemStack)stack);
    }

    protected void chargeMaterial(ItemStack output, int level) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)output);
        enchantments.put(this.enchantment.get(), level);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)output);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.gatherEnergy();
        if (++this.updateTimer > UPDATE_FREQUENCY) {
            if (this.checkStructureLevel()) {
                SilentGear.LOGGER.info("{}} at {}: structure level updated to {}", (Object)this.func_195044_w().func_177230_c().getRegistryName(), (Object)this.field_174879_c, (Object)this.structureLevel);
            }
            this.updateTimer = 0;
        }
        ItemStack input = this.func_70301_a(0);
        ItemStack catalyst = this.func_70301_a(1);
        if (input.func_190926_b() || catalyst.func_190926_b() || !GearApi.isMaterial(input)) {
            return;
        }
        int currentLevel = this.getMaterialChargeLevel(input);
        if (currentLevel < this.structureLevel) {
            this.handleCharging(input, catalyst);
        } else if (this.progress > 0) {
            this.progress = 0;
            this.workTime = 100;
        }
    }

    protected void gatherEnergy() {
        assert (this.field_145850_b != null);
        if (this.charge < this.getMaxCharge() && this.field_145850_b.func_226690_K_() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a())) {
            this.charge += CHARGE_RATE;
        }
    }

    private void handleCharging(ItemStack input, ItemStack catalyst) {
        assert (this.field_145850_b != null);
        int chargeLevel = this.getChargingAgentTier(catalyst);
        int drainRate = this.getDrainRate(input, chargeLevel);
        if (chargeLevel > this.getMaterialChargeLevel(input) && chargeLevel <= this.structureLevel && this.charge >= drainRate && this.wouldFitInOutputSlot(input, chargeLevel)) {
            ++this.progress;
            this.charge -= drainRate;
            this.workTime = this.getWorkTime(input);
            if (this.progress >= this.workTime) {
                if (this.func_70301_a(2).func_190926_b()) {
                    ItemStack output = input.func_77946_l();
                    output.func_190920_e(1);
                    this.chargeMaterial(output, chargeLevel);
                    this.func_70299_a(2, output);
                } else {
                    this.func_70301_a(2).func_190917_f(1);
                }
                this.progress = 0;
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
            }
        }
    }

    private boolean wouldFitInOutputSlot(ItemStack input, int chargeTier) {
        ItemStack output = this.func_70301_a(2);
        if (output.func_190926_b()) {
            return true;
        }
        return output.func_190916_E() < output.func_77976_d() && input.func_77969_a(output) && this.getMaterialChargeLevel(output) == chargeTier && ChargerTileEntity.getGrade(input) == ChargerTileEntity.getGrade(output);
    }

    private static MaterialGrade getGrade(ItemStack stack) {
        IMaterialInstance material = GearApi.getMaterial(stack);
        if (material != null) {
            return material.getGrade();
        }
        return MaterialGrade.NONE;
    }

    protected boolean checkStructureLevel() {
        int oldValue = this.structureLevel;
        this.structureLevel = MathUtils.min((int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.NORTH, 3).func_177967_a(Direction.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.NORTH, 3).func_177967_a(Direction.EAST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.SOUTH, 3).func_177967_a(Direction.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.SOUTH, 3).func_177967_a(Direction.EAST, 3)));
        return this.structureLevel != oldValue;
    }

    protected int getPillarLevel(BlockPos pos) {
        assert (this.field_145850_b != null);
        BlockState state = this.field_145850_b.func_180495_p(pos.func_177981_b(2));
        if (state.func_177230_c() == ModBlocks.CRIMSON_STEEL_BLOCK.get()) {
            return 1;
        }
        if (state.func_177230_c() == ModBlocks.AZURE_ELECTRUM_BLOCK.get()) {
            return 2;
        }
        if (state.func_177230_c() == ModBlocks.TYRIAN_STEEL_BLOCK.get()) {
            return 3;
        }
        return 0;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "material_charger");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return ChargerContainer.createStarlightCharger(id, player, (IInventory)this, this.fields);
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index > 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return GearApi.isMaterial(stack);
        }
        if (index == 1) {
            return stack.func_77973_b().func_206844_a(ModTags.Items.STARLIGHT_CHARGER_CATALYSTS);
        }
        return false;
    }

    public void func_230337_a_(BlockState stateIn, CompoundNBT tags) {
        super.func_230337_a_(stateIn, tags);
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        CompoundNBT compoundTag = super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundNBT)compoundTag, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return compoundTag;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }
}

