/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.silentchaos512.gear.api.GearApi;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TagUtils;
import net.silentchaos512.utils.MathUtils;

public class ChargerContainer
extends Container {
    private final IInventory inventory;
    private final IIntArray fields;

    public ChargerContainer(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer data) {
        this(type, id, inv, (IInventory)ChargerTileEntity.createStarlightCharger(), (IIntArray)new IntArray((int)data.readByte()));
    }

    public ChargerContainer(ContainerType<?> type, int id, PlayerInventory inv, IInventory blockInv, IIntArray fields) {
        super(type, id);
        this.inventory = blockInv;
        this.fields = fields;
        ChargerContainer.func_216962_a((IInventory)this.inventory, (int)3);
        this.func_75146_a(new Slot(this.inventory, 0, 56, 23){

            public boolean func_75214_a(ItemStack stack) {
                return GearApi.isMaterial(stack);
            }
        });
        this.func_75146_a(new Slot(this.inventory, 1, 56, 46){

            public boolean func_75214_a(ItemStack stack) {
                return TagUtils.containsSafe(ModTags.Items.STARLIGHT_CHARGER_CATALYSTS, (ItemStack)stack);
            }
        });
        this.func_75146_a((Slot)new SlotOutputOnly(this.inventory, 2, 116, 35));
        InventoryUtils.createPlayerSlots((PlayerInventory)inv, (int)8, (int)84).forEach(arg_0 -> ((ChargerContainer)this).func_75146_a(arg_0));
        this.func_216961_a(this.fields);
    }

    public static ChargerContainer createStarlightCharger(int id, PlayerInventory inv, PacketBuffer data) {
        return new ChargerContainer((ContainerType)ModContainers.STARLIGHT_CHARGER.get(), id, inv, data);
    }

    public static ChargerContainer createStarlightCharger(int id, PlayerInventory inv, IInventory blockInv, IIntArray fields) {
        return new ChargerContainer((ContainerType)ModContainers.STARLIGHT_CHARGER.get(), id, inv, blockInv, fields);
    }

    public int getWorkProgress() {
        return this.fields.func_221476_a(0);
    }

    public int getWorkTime() {
        return this.fields.func_221476_a(1);
    }

    public int getStructureLevel() {
        return this.fields.func_221476_a(2);
    }

    public int getCharge() {
        int upper = this.fields.func_221476_a(4) & 0xFFFF;
        int lower = this.fields.func_221476_a(3) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getMaxCharge() {
        int upper = this.fields.func_221476_a(6) & 0xFFFF;
        int lower = this.fields.func_221476_a(5) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getChargeMeterHeight() {
        int max = this.getMaxCharge();
        int clamped = MathUtils.clamp((int)this.getCharge(), (int)0, (int)max);
        return max > 0 ? 50 * clamped / max : 0;
    }

    public int getProgressArrowScale() {
        int progress = this.getWorkProgress();
        int workTime = this.getWorkTime();
        return progress != 0 && workTime > 0 ? progress * 24 / workTime : 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int size;
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            int startPlayer = size = this.inventory.func_70302_i_();
            int endPlayer = size + 27;
            int startHotbar = size + 27;
            int endHotbar = size + 36;
            if (index == 2 ? !this.func_75135_a(stack1, startPlayer, endHotbar, true) : (index >= size && this.inventory.func_94041_b(0, stack1) ? !this.func_75135_a(stack1, 0, 1, false) : (index >= size && this.inventory.func_94041_b(1, stack1) ? !this.func_75135_a(stack1, 1, 2, false) : (index >= startPlayer && index < endPlayer ? !this.func_75135_a(stack1, startHotbar, endHotbar, false) : (index >= startHotbar && index < endHotbar ? !this.func_75135_a(stack1, startPlayer, endPlayer, false) : !this.func_75135_a(stack1, startPlayer, endHotbar, false)))))) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack1);
        }
        return stack;
    }
}

