/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.util.TextUtil;

public interface ITrait {
    public ResourceLocation getId();

    public int getMaxLevel();

    public Collection<ITraitCondition> getConditions();

    public boolean willCancelWith(ITrait var1);

    default public int getCanceledLevel(int level, ITrait other, int otherLevel) {
        if (this.willCancelWith(other)) {
            int diff = level - otherLevel;
            return diff < 0 ? MathHelper.func_76125_a((int)diff, (int)(-other.getMaxLevel()), (int)0) : MathHelper.func_76125_a((int)diff, (int)0, (int)this.getMaxLevel());
        }
        return level;
    }

    default public void retainData(@Nullable ITrait oldTrait) {
    }

    public IFormattableTextComponent getDisplayName(int var1);

    public IFormattableTextComponent getDescription(int var1);

    default public boolean isHidden() {
        return false;
    }

    default public boolean showInTooltip(ITooltipFlag flag) {
        return !this.isHidden() || flag.func_194127_a();
    }

    @Deprecated
    default public void addInformation(int level, List<ITextComponent> tooltip) {
        this.addInformation(level, tooltip, () -> false);
    }

    default public void addInformation(int level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        this.addInformation(level, tooltip, flag, t -> t);
    }

    default public void addInformation(int level, List<ITextComponent> tooltip, ITooltipFlag flag, Function<ITextComponent, ITextComponent> affixFirst) {
        if (!this.showInTooltip(flag)) {
            return;
        }
        IFormattableTextComponent displayName = TextUtil.withColor(this.getDisplayName(level), this.isHidden() ? TextFormatting.DARK_GRAY : TextFormatting.GRAY);
        displayName.func_150256_b().func_240712_a_(TextFormatting.ITALIC);
        tooltip.add(affixFirst.apply((ITextComponent)displayName));
        if (KeyTracker.isDisplayTraitsDown()) {
            IFormattableTextComponent description = TextUtil.withColor(this.getDescription(level), TextFormatting.DARK_GRAY);
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)description));
        }
    }

    public ITraitSerializer<?> getSerializer();

    public float onAttackEntity(TraitActionContext var1, LivingEntity var2, float var3);

    public float onDurabilityDamage(TraitActionContext var1, int var2);

    public void onGearCrafted(TraitActionContext var1);

    public void onRecalculatePre(TraitActionContext var1);

    public void onRecalculatePost(TraitActionContext var1);

    public float onGetStat(TraitActionContext var1, ItemStat var2, float var3, float var4);

    public void onGetAttributeModifiers(TraitActionContext var1, Multimap<Attribute, AttributeModifier> var2, String var3);

    @Deprecated
    default public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, EquipmentSlotType slot) {
        this.onGetAttributeModifiers(context, modifiers, slot.func_188450_d());
    }

    public ActionResultType onItemUse(ItemUseContext var1, int var2);

    public void onItemSwing(ItemStack var1, LivingEntity var2, int var3);

    public void onUpdate(TraitActionContext var1, boolean var2);

    public ItemStack addLootDrops(TraitActionContext var1, ItemStack var2);

    default public CompoundNBT write(int level) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Name", this.getId().toString());
        tag.func_74774_a("Level", (byte)level);
        return tag;
    }

    default public Collection<String> getCancelsWithSet() {
        return Collections.emptySet();
    }

    default public Collection<String> getExtraWikiLines() {
        return Collections.emptyList();
    }
}

