/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.gear.part.PartTextureSet;

public class MaterialLayerList
implements IMaterialLayerList {
    public static final MaterialLayerList DEFAULT = new MaterialLayerList();
    private final List<MaterialLayer> layers;
    private PartTextureSet oldTextureType = PartTextureSet.ABSENT;

    public MaterialLayerList() {
        this.layers = new ArrayList<MaterialLayer>();
    }

    public MaterialLayerList(PartType partType, PartTextureSet texture, int color) {
        this(texture.getLayers(partType).stream().map(PartTextures::getTexture).map(tex -> {
            int c = tex.equals((Object)SilentGear.getId("_highlight")) ? 0xFFFFFF : color;
            return new MaterialLayer((ResourceLocation)tex, partType, c, false);
        }).collect(Collectors.toList()));
        this.oldTextureType = texture;
    }

    public MaterialLayerList(MaterialLayer ... layers) {
        this(Arrays.asList(layers));
    }

    public MaterialLayerList(List<MaterialLayer> layers) {
        this.layers = new ArrayList<MaterialLayer>(layers);
    }

    @Override
    public List<MaterialLayer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    @Override
    @Deprecated
    public PartTextureSet getTexture() {
        return this.oldTextureType;
    }

    @Override
    public int getPrimaryColor() {
        if (!this.layers.isEmpty()) {
            return this.layers.get(0).getColor();
        }
        return 0xFFFFFF;
    }

    public JsonElement serialize() {
        JsonArray jsonLayers = new JsonArray();
        this.layers.forEach(layer -> jsonLayers.add(layer.serialize()));
        return jsonLayers;
    }

    public static MaterialLayerList deserialize(PartGearKey key, JsonElement json, IMaterialLayerList defaultProps) {
        MaterialLayerList props = new MaterialLayerList();
        JsonArray jsonLayers = json.getAsJsonArray();
        if (jsonLayers != null) {
            for (JsonElement je : jsonLayers) {
                props.layers.add(MaterialLayer.deserialize(key, je));
            }
        }
        return props;
    }

    public static MaterialLayerList read(PacketBuffer buffer) {
        MaterialLayerList props = new MaterialLayerList();
        int layerCount = buffer.readByte();
        for (int i = 0; i < layerCount; ++i) {
            props.layers.add(MaterialLayer.read(buffer));
        }
        return props;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeByte(this.layers.size());
        this.layers.forEach(layer -> layer.write(buffer));
    }

    public String toString() {
        return "MaterialLayerList{layers=" + this.layers + '}';
    }

    @Override
    public Iterator<MaterialLayer> iterator() {
        return this.layers.iterator();
    }
}

