/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.init.Registration;

public final class GearType {
    private static final Pattern VALID_NAME = Pattern.compile("[^a-z_]");
    private static final Map<String, GearType> VALUES = new HashMap<String, GearType>();
    private static final Map<GearType, ICoreItem> ITEMS = new HashMap<GearType, ICoreItem>();
    public static final GearType NONE = GearType.getOrCreate("none");
    public static final GearType ALL = GearType.getOrCreate("all");
    public static final GearType PART = GearType.getOrCreate("part");
    public static final GearType FRAGMENT = GearType.getOrCreate("fragment");
    public static final GearType PROJECTILE = GearType.getOrCreate("projectile", ALL);
    public static final GearType TOOL = GearType.getOrCreate("tool", ALL);
    public static final GearType WEAPON = GearType.getOrCreate("weapon", TOOL);
    public static final GearType HARVEST_TOOL = GearType.getOrCreate("harvest_tool", TOOL);
    public static final GearType AXE = GearType.getOrCreate("axe", HARVEST_TOOL);
    public static final GearType PICKAXE = GearType.getOrCreate("pickaxe", HARVEST_TOOL);
    public static final GearType SHOVEL = GearType.getOrCreate("shovel", HARVEST_TOOL);
    public static final GearType EXCAVATOR = GearType.getOrCreate("excavator", SHOVEL);
    public static final GearType HAMMER = GearType.getOrCreate("hammer", PICKAXE);
    public static final GearType SAW = GearType.getOrCreate("saw", AXE);
    public static final GearType MATTOCK = GearType.getOrCreate("mattock", HARVEST_TOOL);
    public static final GearType PAXEL = GearType.getOrCreate("paxel", HARVEST_TOOL);
    public static final GearType PROSPECTOR_HAMMER = GearType.getOrCreate("prospector_hammer", PICKAXE);
    public static final GearType SHEARS = GearType.getOrCreate("shears", HARVEST_TOOL);
    public static final GearType SICKLE = GearType.getOrCreate("sickle", HARVEST_TOOL);
    public static final GearType MELEE_WEAPON = GearType.getOrCreate("melee_weapon", WEAPON);
    public static final GearType DAGGER = GearType.getOrCreate("dagger", MELEE_WEAPON);
    public static final GearType KATANA = GearType.getOrCreate("katana", MELEE_WEAPON);
    public static final GearType KNIFE = GearType.getOrCreate("knife", MELEE_WEAPON);
    public static final GearType MACHETE = GearType.getOrCreate("machete", MELEE_WEAPON);
    public static final GearType SPEAR = GearType.getOrCreate("spear", MELEE_WEAPON);
    public static final GearType SWORD = GearType.getOrCreate("sword", MELEE_WEAPON);
    public static final GearType RANGED_WEAPON = GearType.getOrCreate("ranged_weapon", WEAPON);
    public static final GearType BOW = GearType.getOrCreate("bow", RANGED_WEAPON);
    public static final GearType CROSSBOW = GearType.getOrCreate("crossbow", RANGED_WEAPON);
    public static final GearType SLINGSHOT = GearType.getOrCreate("slingshot", RANGED_WEAPON);
    public static final GearType FISHING_ROD = GearType.getOrCreate("fishing_rod", TOOL);
    public static final GearType SHIELD = GearType.getOrCreate("shield", TOOL, () -> ItemStats.ARMOR_DURABILITY);
    public static final GearType ARMOR = GearType.getOrCreate("armor", ALL, () -> ItemStats.ARMOR_DURABILITY);
    public static final GearType BOOTS = GearType.getOrCreate("boots", ARMOR);
    public static final GearType CHESTPLATE = GearType.getOrCreate("chestplate", ARMOR);
    public static final GearType ELYTRA = GearType.getOrCreate("elytra", ARMOR);
    public static final GearType HELMET = GearType.getOrCreate("helmet", ARMOR);
    public static final GearType LEGGINGS = GearType.getOrCreate("leggings", ARMOR);
    public static final GearType ARROW = GearType.getOrCreate("arrow", PROJECTILE);
    public static final GearType CURIO = GearType.getOrCreate("curio", ALL);
    public static final GearType BRACELET = GearType.getOrCreate("bracelet", CURIO);
    public static final GearType RING = GearType.getOrCreate("ring", CURIO);
    private final String name;
    @Nullable
    private final GearType parent;
    private final int animationFrames;
    private final Supplier<ItemStat> durabilityStat;

    public static GearType get(String name) {
        return VALUES.getOrDefault(name, NONE);
    }

    public static GearType getOrCreate(String name) {
        return GearType.getOrCreate(name, null);
    }

    public static GearType getOrCreate(String name, @Nullable GearType parent) {
        return GearType.getOrCreate(name, parent, 1);
    }

    public static GearType getOrCreate(String name, @Nullable GearType parent, int animationFrames) {
        Supplier<ItemStat> durabilityStat = () -> parent != null ? parent.durabilityStat.get() : ItemStats.DURABILITY;
        return GearType.getOrCreate(name, parent, animationFrames, durabilityStat);
    }

    @Deprecated
    public static GearType getOrCreate(String name, @Nullable GearType parent, ItemStat durabilityStat) {
        return GearType.getOrCreate(name, parent, () -> durabilityStat);
    }

    public static GearType getOrCreate(String name, @Nullable GearType parent, Supplier<ItemStat> durabilityStat) {
        return GearType.getOrCreate(name, parent, 1, durabilityStat);
    }

    @Deprecated
    public static GearType getOrCreate(String name, @Nullable GearType parent, int animationFrames, ItemStat durabilityStat) {
        return GearType.getOrCreate(name, parent, animationFrames, () -> durabilityStat);
    }

    public static GearType getOrCreate(String name, @Nullable GearType parent, int animationFrames, Supplier<ItemStat> durabilityStat) {
        if (VALID_NAME.matcher(name).find()) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return VALUES.computeIfAbsent(name, k -> new GearType(name, parent, animationFrames, durabilityStat));
    }

    public static GearType fromJson(JsonObject json, String key) {
        String str = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        GearType type = GearType.get(str);
        if (type.isInvalid()) {
            throw new JsonSyntaxException("Unknown gear type: " + str);
        }
        return type;
    }

    private GearType(String name, @Nullable GearType parent, int animationFrames, Supplier<ItemStat> durabilityStat) {
        this.name = name;
        this.parent = parent;
        this.animationFrames = animationFrames;
        this.durabilityStat = durabilityStat;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public GearType getParent() {
        return this.parent;
    }

    public int getAnimationFrames() {
        return this.animationFrames;
    }

    public ItemStat getDurabilityStat() {
        return this.durabilityStat.get();
    }

    public boolean matches(String type) {
        return this.matches(type, true);
    }

    public boolean matches(GearType type) {
        return this.matches(type.name, true);
    }

    public boolean matches(String type, boolean includeAll) {
        if (type.contains("/")) {
            return this.matches(type.split("/")[1], includeAll);
        }
        return includeAll && "all".equals(type) || this.name.equals(type) || this.parent != null && this.parent.matches(type, includeAll);
    }

    public boolean matches(GearType type, boolean includeAll) {
        return this.matches(type.name, includeAll);
    }

    public boolean isGear() {
        return this.matches(ALL, false);
    }

    public boolean isArmor() {
        return this.matches(ARMOR);
    }

    public boolean isInvalid() {
        return this == NONE;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("gearType.silentgear." + this.name);
    }

    public Optional<ICoreItem> getItem() {
        return Optional.ofNullable(ITEMS.computeIfAbsent(this, gearType -> Registration.getItems(ICoreItem.class).stream().filter(item -> item.getGearType() == gearType).findAny().orElse(null)));
    }

    public Collection<ItemStat> getRelevantStats() {
        return this.getItem().map(item -> item.getRelevantStats(ItemStack.field_190927_a)).orElse(ItemStats.allStatsOrdered());
    }

    public Set<ItemStat> getExcludedStats() {
        return this.getItem().map(item -> item.getExcludedStats(ItemStack.field_190927_a)).orElse(Collections.emptySet());
    }

    public GearTypeMatcher getMatcher(boolean matchParents) {
        return new GearTypeMatcher(matchParents, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GearType gearType = (GearType)o;
        return this.name.equals(gearType.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "GearType{name='" + this.name + '\'' + ", parent=" + this.parent + '}';
    }
}

